block('b-content-promotion-video-href')(
    js()(function() {
        return {
            modelParams: {
                name: 'b-content-promotion-video-href',
                id: this.ctx.modelId,
            },
            modelData: {
                video_href: this.ctx.video_href
            },
            errorPath: this.ctx.errorPath
        };
    }),

    content()(function() {
        return [
            {
                block: 'input',
                mods: {
                    size: 's',
                    theme: 'normal'
                },
                mix: [
                    {
                        block: 'b-content-promotion-video-href',
                        elem: 'input'
                    },
                    {
                        block: 'b-content-promotion-video-href',
                        elem: 'model-field',
                        js: [
                            {
                                name: 'video_href',
                                type: 'input'
                            },
                            {
                                name: 'check_video_in_progress',
                                type: 'mod',
                                block: 'input',
                                modName: 'disabled'
                            }
                        ]
                    }
                ],
                placeholder: iget2('b-content-promotion-video-href', 'add-video-link', 'Добавьте ссылку на видео'),
                content: { elem: 'control' },
                value: this.ctx.video_href
            },
            {
                block: 'spin2',
                mods: {
                    size: 'xxs'
                },
                mix: [
                    {
                        block: 'b-content-promotion-video-href',
                        elem: 'spinner'
                    },
                    {
                        block: 'b-content-promotion-video-href',
                        elem: 'model-field',
                        js: {
                            name: 'check_video_in_progress',
                            type: 'mod',
                            block: 'spin2',
                            modName: 'progress'
                        }
                    }
                ]
            }
        ];
    })
);
