BEM.DOM.decl({ block: 'b-content-promotion-video-href', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._input = this.findBlockOn('input', 'input');
            this._errorPresenter = this.findBlockOutside('b-errors-presenter2');

            this.model.init();

            this._subscriptionManager.wrap(this.model)
                .on('change', function() {
                    this.model.syncToDM();
                }, this)
                .on('video_href', 'change', function() {
                    this.model.clear('content_promotion_video_id');
                    this.model.clear('video_href_checked');
                }, this);

            this._subscriptionManager.wrap(this._input)
                .on('focus', this._onInputFocus, this)
                .on('blur', this._onInputBlur, this);
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base.apply(this, arguments);
    },

    _getHref: function() {
        return this.model.get('video_href');
    },

    _onInputFocus: function() {
        this._inputValue = this._getHref();
    },

    _onInputBlur: function() {
        var value = this._getHref();

        if (value === this._inputValue) {
            return;
        }
        // если ссылка поменялась
        this._checkVideoHref();
    },

    _checkVideoHref: function() {
        if (!this._validateHref()) {
            return;
        }
        this.model.set('check_video_in_progress', true);

        this._requestVideoPreview()
            .then(function(data) {
                this.model.update(data);
            }.bind(this))
            .catch(function(data) {
                this.model.update(data.modelData);
                switch (data.errStatus) {
                    case 500:
                        this._showError(iget2('b-content-promotion-video-href', 'internal-server-error', 'Внутренняя ошибка сервера'));
                        break;
                    case 410:
                        this._showError(iget2('b-content-promotion-video-href', 'video-gone', 'Видео недоступно'));
                        break;
                    default:
                        this._showError(iget2('b-content-promotion-video-href', 'url-not-video', 'Введенное значение не является ссылкой на видеоматериал'));
                }
            }.bind(this));
    },

    _validateHref: function() {
        if (!u.isUrl(this._getHref())) {
            this.model.clear('video_preview_image_href');
            return this._showError(iget2('b-content-promotion-video-href', 'not-url', 'Введенное значение не является ссылкой'));
        }
        this._clearError();
        return true;
    },

    _requestVideoPreview: function() {
        return BEM.blocks['i-web-api-request'].contentPromotion
            .getContentPromotionMetadata(u.consts('ulogin'), 'video', this._getHref())
            .then(function(data) {
                return {
                    video_preview_image_href: data.result.preview_url,
                    title: data.result.title,
                    description: data.result.description,
                    content_promotion_video_id: data.result.content_id,
                    video_href_checked: true,
                    check_video_in_progress: false
                };
            })
            .catch(function(err) {
                throw {
                    modelData: {
                        video_preview_image_href: undefined,
                        content_promotion_video_id: undefined,
                        video_href_checked: true,
                        check_video_in_progress: false
                    },
                    errStatus: err.status
                };
            })
    },

    _showError: function(errorText) {
        if (this._errorPresenter) {
            this._errorPresenter.showErrors([{
                path: this.params.errorPath + '.video_href',
                description: errorText
            }]);
        }
    },

    _clearError: function() {
        if (this._errorPresenter) {
            this._errorPresenter.clearErrors();
        }
    },

    clear: function() {
        this.model.clear();
    }
});
