u.register({
    'b-content-promotion-video-href': {
        getModelFields: function(withValidation) {
            var fields = {
                video_href: {
                    type: 'string',
                    validation: {
                        needToValidate: function() {
                            return this.get('content_promotion_content_type') === 'video';
                        },
                        rules: {
                            required: { text: iget2('b-content-promotion-video-href', 'href-mandatory', 'Невозможно создать объявление без видео') },
                            shouldBeUrl: {
                                validate: function(val) {
                                    return u.isUrl(val);
                                },
                                text: function() {
                                    return iget2('b-content-promotion-video-href', 'not-url', 'Введенное значение не является ссылкой');
                                },
                                needToValidate: function(val) {
                                    return !!val;
                                }
                            },
                            shouldBeVideoHref: {
                                validate: function() {
                                    return !!this.get('content_promotion_video_id');
                                },
                                text: function() {
                                    return iget2('b-content-promotion-video-href', 'url-not-video', 'Введенное значение не является ссылкой на видеоматериал');
                                },
                                needToValidate: function() {
                                    return this.get('video_href_checked');
                                }
                            }
                        }
                    }
                },

                video_preview_image_href: 'string',

                check_video_in_progress: {
                    type: 'boolean',
                    default: false
                },

                content_promotion_video_id: {
                    type: 'string'
                },

                video_href_checked: {
                    type: 'boolean',
                    default: false
                },

                title: {
                    type: 'string',
                    validation: {
                        needToValidate: function() {
                            return this.get('content_promotion_content_type') === 'video';
                        },
                        rules: {
                            required: { text: iget2('b-content-promotion-video-href', 'title-mandatory', 'Заголовок не может быть пустым') },
                        }
                    }
                },

                description: {
                    type: 'string',
                    validation: {
                        needToValidate: function() {
                            return this.get('content_promotion_content_type') === 'video';
                        },
                        rules: {
                            required: { text: iget2('b-content-promotion-video-href', 'description-mandatory', 'Описание не может быть пустым') },
                        }
                    }
                }
            };

            if (!withValidation) {
                Object.keys(fields).forEach(function(key) {
                    delete fields[key].validation;
                });
            }

            return fields;
        }
    }
});

BEM.MODEL.decl({ model: 'b-content-promotion-video-href', baseModel: 'vm-sync-dm' }, Object.assign({}, u['b-content-promotion-video-href'].getModelFields(), {
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-content-promotion-banner',
                id: this.id
            };
        }
    }
}));
