/**
 * @param {Object} [options] - настройки превью
 * @param {String} [options.scrollId] - id блока к которму проскролится превью
 * @param {DataToPcode.ads[]} banner - данные баннера
 */
BEM.DOM.decl({ name: 'b-context-preview', implements: 'i-preview-tab-interface' }, {

    onSetMod: {
        js: function() {
            this._iframe = this.findBlockOn('iframe', 'i-foreign-iframe');
        }
    },

    /**
     * Инициализация iframe'а партнерского кода
     * @private
     */
    _initPcodeIframeEvents: function() {
        var options = this.params.options || {},
            bannerData = this.params.banner || {},
            message = {
                showHeader: false,
                directPreview: bannerData
            };

        options.scrollId && (message.scrollId = options.scrollId);

        this._iframe.postMessage(JSON.stringify(message), '*');
    },

    /**
     * Обработчик события load вложенного блока i-foreign-iframe
     * @param {Event} e
     * @private
     */
    _onForeignIframeLoad: function(e) {
        this._initPcodeIframeEvents();
    },

    /**
     * Вызывается при активации превью
     */
    onEnable: function() {
        // сейчас не используется
    },

    /**
     * Вызывается при выключении превью
     */
    onDisable: function() {
        // сейчас не используется
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('load', 'i-foreign-iframe', function(e) {
            this._onForeignIframeLoad(e);
        });
    }

});
