BEM.DOM.decl({ block: 'b-control-input', baseBlock: 'b-control' }, {
    onSetMod: {
        js: function() {
            this._getInnerBlock().on(this.params.action, function(e, data) {
                this._doNotify(e.type, e.block);
            }, this)
        },

        state: function(modName, modVal) {
            this._getInnerBlock().setMod('disabled', modVal == 'disabled' ? 'yes' : '');
        },

        error: function(modName, modVal) {
            this._getInnerBlock().setMod('error', modVal);
        }
    },

    _doNotify: function(actionName, target) {
        var control = this._getControlBlock();

        control.trigger('actionRequested', {
            action: actionName,
            data: this.params.data,
            value: this._getInnerBlock().val(),
            target: target
        });
    },

    _getInnerBlock: function() {
        return this._input || (this._input = this.findBlockInside(this.params.inputName));
    }

});
