/**
 * Расходы по всем кампаниям
 *
 * @param ctx.currentCurrency валюта
 * @param ctx.outlay данные по расходу по всем кампаниям
 *
 * @namespace b-costs-campaigns
 */
block('b-costs-campaigns')(

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'title',
                content: iget2('b-costs-campaigns', 'rashod-po-vsem-kampaniyam', 'Расход по всем кампаниям')
            },
            [
                {
                    label: iget2('b-costs-campaigns', 'vchera', 'Вчера'),
                    value: ctx.outlay.day
                },
                {
                    label: iget2('b-costs-campaigns', '7-dney', '7 дней'),
                    value: ctx.outlay.week
                },
                {
                    label: iget2('b-costs-campaigns', '30-dney', '30 дней'),
                    value: ctx.outlay.month
                }
            ].map(function(item) {
                return {
                    elem: 'row',
                    content: [
                        {
                            elem: 'label',
                            content: item.label
                        },
                        {
                            elem: 'value',
                            content: u.currencies.formatSum(ctx.currentCurrency, item.value)
                        }
                    ]
                }
            })
        ];
    })
);
