BEM.DOM.decl({ block: 'b-creative-group-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _creativeWrapper: 'b-creative-wrapper inside body',
                _cancelButton: 'button on cancel'
            });

            this._saveButton = this.findBlockOn('save', 'button');

            this._saveButton && this._subscriptionManager.wrap(this._creativeWrapper)
                .on('data-loading:start', function() {
                    this._saveButton.setMod('disabled', 'yes');
                }, this)
                .on('data-loading:end selectedChanged', function() {
                    this.trigger('repaint');
                    this._saveButton.setMod('disabled', this._creativeWrapper.getSelectedIds().length ? '' : 'yes');
                }, this);
            this._saveButton && this._subscriptionManager.on(this._saveButton, 'click', this._onSaveClick, this);
            this._subscriptionManager.on(this._cancelButton, 'click', this._onCancelClick, this);

        }
    },

    /**
     * Содержимое блока изменилось
     * @returns {Promise}
     */
    isChanged: function() {
        return $.Deferred().resolve(this._creativeWrapper.isSelectedChanged()).promise();
    },

    /**
     * Удаление блока
     * @returns {BEM}
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик клика по кнопке "Отмена"
     * @private
     */
    _onCancelClick: function() {
        this.trigger('cancel');
    },

    /**
     * Обработчик клика по любой кнопке "Сохранить"
     * @private
     */
    _onSaveClick: function() {
        this.trigger('save', {
            selectedCreatives: this._creativeWrapper.getSelectedIds()
        });
    }
}, {});
