block('b-creative-group')(
    def()(function() {
        var group = this.ctx.group;

        return applyNext({
            'mods.deprecated': u['b-creative-group'].idDeprecated(group) ? 'yes' : '',
            'mods.multiple': group.creatives_data.length > 1 ? 'yes' : '',
            'mods.state': u['b-creative-group'].calcGroupState(group.selected_data, group.creatives_data)
        });
    }),

    js()(function() {
        return {
            modelData: this.ctx.group,
            controlsType: this.ctx.controlsType,
            filters: this.ctx.filters,
            search: this.ctx.search
        }
    }),

    content()(function() {
        var group = this.ctx.group;

        return [
            {
                elem: 'content-wrap',
                content: [
                    {
                        elem: 'preview',
                        controlsType: this.ctx.controlsType,
                        group: group
                    },
                    {
                        elem: 'footer',
                        group: group
                    },
                    {
                        block: 'button2',
                        mods: { theme: 'clear', size: 's' },
                        mix: { block: 'b-creative-group', elem: 'show-all-btn' },
                        content: iget2('b-creative-group', 'pokazat-vse', 'Показать все')
                    }
                ]
            }
        ];
    }),

    elem('footer').content()(function() {
        return [
            u.escapeHTML(this.ctx.group.name),
            {
                elem: 'count',
                selectedCount: (this.ctx.group.selected_data || []).length,
                totalCount: (this.ctx.group.creatives_data || []).length
            }

        ]
    }),

    elem('count').content()(function() {
        if (!!this.ctx.selectedCount && this.ctx.selectedCount > 0 && this.ctx.selectedCount !== this.ctx.totalCount) {
            return iget2('b-creative-group', 's-iz-s', '{foo} из {bar}', {
                foo: this.ctx.selectedCount,
                bar: this.ctx.totalCount
            });
        } else {
            return this.ctx.totalCount;
        }
    }),

    elem('preview').def()(function() {
        var group = this.ctx.group;

        return applyCtx({
            block: 'link',
            mix: { block: 'b-creative-group', elem: 'preview' },
            content: [
                {
                    block: 'b-creative-group',
                    elem: 'thumb',
                    content: {
                        block: 'image',
                        url: group.preview_url,
                        alt: group.alt
                    }
                },
                //ссылка "Редактировать" есть только на странице редактирования для не-deprecated групп
                this.ctx.controlsType == 'edit' && (group.group_id !== '0') && {
                    block: 'b-creative-group',
                    elem: 'edit',
                    content: iget2('b-creative-group', 'redaktirovat', 'Редактировать')
                }
            ]
        });
    })
);
