BEM.DOM.decl({ block: 'b-creative-group', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');
        }
    },

    /**
     * Удаление блока
     * @returns {BEM}
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Пользователь кликнул на кнопку "Показать все"
     * @private
     */
    _onShowCreativesBtnClick: function() {
        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(
                null,
                { adaptive: 'yes', 'child-state': 'yes', bodyScroll: false },
                $
            ),
            groupCreativesPopup = popupDecorator.setPopupContent({
                block: 'b-creative-group-popup',
                name: this.model.get('name'),
                groupId: this.model.get('group_id'),
                selectedItemsIds: this.model.get('selected_data'),
                controlsType: this.params.controlsType,
                filters: this.params.filters,
                search: this.params.search
            }),
            //если блок с креативами сам в попапе - попробуем найти его родителя
            parentPopup = this.findBlockOutside({ block: 'popup', modName: 'for', modVal: 'choose-creative' });

        parentPopup && popupDecorator.getPopup().setParent(parentPopup);

        this._subscriptionManager
            .on(groupCreativesPopup, 'save', function(e, data) {
                this._updateCounterText();

                popupDecorator.hide({ force: true });
            }, this)
            .on(groupCreativesPopup, 'cancel', function() {
                popupDecorator.hide()
            }, this)
            .on(popupDecorator, 'close-blocked', function(e) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-creative-group', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: popupDecorator.getPopup(),
                    onYes: function() {
                        popupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .on(popupDecorator, 'close', function() {
                popupDecorator.destruct();
            }, this);

        popupDecorator.show();
    },

    /**
     * Пользователь нажал на ссылку "Редактировать"
     * @private
     */
    _onEditLinkClick: function() {
        if (this.getMod('deprecated') != 'yes') {
            var modelData = this.params.modelData,
                creatives = modelData.creatives_data;

            this.trigger('editCreatives', {
                creatives_data: creatives,
                groupId: modelData.total_counts == creatives.length && modelData.group_id
            });
        }
    },

    /**
     * Устанавливает значение счетчика выбранных баннеров
     */
    _updateCounterText: function() {
        BEM.DOM.replace(this.findElem('count'), BEMHTML.apply({
            block: 'b-creative-group',
            elem: 'count',
            selectedCount: this.model.get('selected_data').length,
            totalCount: this.model.get('creatives_data').length
        }));
    }
}, {
    live: function() {
        this
            .liveBindTo('preview', 'click', function() {
                this._onEditLinkClick();
            })
            .liveInitOnBlockInsideEvent('click', 'button2', function() {
                this._onShowCreativesBtnClick()
            });
    }
});
