u.register({
    'b-creative-group': {

        /**
         * Вычисляет модификатор state для группы креативов
         * @param {Array} selectedCreativesList
         * @param {Array} allCreativesList
         * @returns {String}
         */
        calcGroupState: function(selectedCreativesList, allCreativesList) {
            selectedCreativesList = selectedCreativesList || [];
            allCreativesList = allCreativesList || [];

            return selectedCreativesList.length == 0 ?
                '' :
                selectedCreativesList.length == allCreativesList.length ?
                    'checked' :
                    'indeterminate';
        },

        /**
         * Группа является устаревшей
         * @param {Object} group
         * @param {String} group.group_id
         * @returns {boolean}
         */
        idDeprecated: function(group) {
            return group.group_id == '0';
        },

        /**
         * Облагораживаем серверные данные для группы креативов
         * @param {Object} data данные пришедшие с сервера
         * @returns {Object}
         */
        prepareServerData: function(data) {
            //Фейковая группа, в которой содержатся креативы предыдущего поколения должна прийти без id.
            //Ей присваивается id = '0' (по id == '0' сервер споследствии понимает, что ему пришла deprecated-группа)
            if (!data.group_id) {
                data.group_id = '0';
                data.name = iget2('b-creative-group', 'kreativy-predydushchey-versii', 'Креативы предыдущей версии');
            }

            data.creatives_data = data.creatives_data.map(function(creative) {
                creative.creative_group_id = data.group_id;

                return creative;
            });

            return data;
        }
    }
});
