block('b-creative-groups-list')(

    js()(function() {
        return {
            items: this.ctx.items,
            modelData: {
                selectedItemsIds: this.ctx.selectedItemsIds || [],
                isSearch: this.ctx.isSearch,
                fromChanged: this.ctx.fromChanged
            },
            filters: this.ctx.filters || [],
            search: this.ctx.search || [],
            controlsType: this.ctx.controlsType
        };
    }),

    elem('items-wrapper').def()(function() {
        return applyCtx({
            elem: 'empty-message',
            content: this.ctx.isSearch ? iget2('b-creative-groups-list', 'po-vashemu-zaprosu-nichego', 'По вашему запросу ничего не найдено') : iget2('b-creative-groups-list', 'poisk-ne-dal-rezultatov', 'Поиск не дал результатов')
        });
    }),

    elem('items-wrapper').match(function() {
        return this.ctx.items && this.ctx.items.length;
    }).def()(function() {
        return applyCtx({
            elem: 'items',
            tag: 'ul',
            content: this.ctx.items.map(function(item) {
                return {
                    elem: 'item',
                    group: item,
                    filters: this.ctx.filters,
                    search: this.ctx.search,
                    controlsType: this.ctx.controlsType
                }
            }, this)
        });
    }),

    elem('item').def()(function() {
        var group = this.ctx.group;

        return applyCtx({
            block: 'b-creative-group',
            tag: 'li',
            controlsType: this.ctx.controlsType,
            filters: this.ctx.filters,
            search: this.ctx.search,
            mix: { block: 'b-creative-groups-list', elem: 'item' },
            group: group
        });
    })
);
