BEM.DOM.decl({ block: 'b-creative-groups-list', baseBlock: 'i-glue', implements: 'i-creatives-list-interface' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._renderItemsList();
        }
    },

    /**
     * Изменился ли список выбранных элементов
     * @returns {Boolean}
     */
    isSelectedChanged: function() {
        return this.model.isChanged('selectedItemsIds') || this.model.get('fromChanged');
    },

    /**
     * Возвращает массив с выбранными креативами
     * @returns {Object[]}
     */
    getSelectedIds: function() {
        return [].concat(this.model.get('selectedItemsIds'));
    },

    /**
     * Добавление элементов в список
     * @param {Object[]} groups
     */
    addItems: function(groups) {
        this._selected = [];

        var items = this.model.addItems(groups);

        BEM.DOM.append(this.findElem('items'), BEMHTML.apply(items.map(function(item) {
            return {
                block: 'b-creative-groups-list',
                elem: 'item',
                group: item,
                filters: this.params.filters,
                search: this.params.search,
                controlsType: this.params.controlsType
            }
        }, this)));
    },

    _renderItemsList: function() {
        var items = [].concat(this.model.updateItemsList(this.params.items));

        BEM.DOM.update(this.domElem, BEMHTML.apply({
            block: 'b-creative-groups-list',
            elem: 'items-wrapper',
            items: items,
            filters: this.params.filters,
            search: this.params.search,
            controlsType: this.params.controlsType,
            isSearch: this.model.get('isSearch')
        }))
    },

    _onSelectedChanged: function() {
        var selected = [];

        this.findBlocksInside('b-creative-group').forEach(function(group) {
            selected = selected.concat(group.getSelectedIds())
        }, this);

        this.model.set('selectedItemsIds', selected);

        this.trigger('selectedChanged', { selected: selected });
    }
}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('selectedChanged', 'b-creative-group', function() {
                this._onSelectedChanged();
            })
            .liveInitOnBlockInsideEvent('editCreatives', 'b-creative-group', function(e, data) {
                this.trigger('editCreatives', data);
            });
    }
});
