BEM.MODEL.decl('b-creative-groups-list', {
    /**
     * список креативов
     */
    items: {
        type: 'models-list',
        modelName: 'b-creative-group'
    },

    // значит что блок сформировался из данных, которые были изменены пользователем ранее
    fromChanged: 'boolean',

    selectedItemsIds: 'array',

    isSearch: 'boolean'

}, {
    /**
     * Добавляем новые группы в модель
     * @param {Array} groups
     * @returns {Array}
     */
    addItems: function(groups) {
        var groupsModelsList = this.get('items');

        groups = this._prepareDataFromDM(groups);

        groups.forEach(function(item) {
            groupsModelsList.add(item);
        });

        return groups;
    },

    /**
     * Обновляем список групп в модели
     * @param {Array} groups
     * @returns {Array}
     */
    updateItemsList: function(groups) {
        groups = this._prepareDataFromDM(groups);

        this.update({
            groups: groups
        });

        return groups;
    },

    _prepareDataFromDM: function(groups) {
        return groups.map(function(group) {
            //выбираем из всех выбранных креативов selectedItemsIds те, которые находятся в данной группе
            group.selected_data = this.get('selectedItemsIds').filter(function(selectedItem) {
                return u._.findIndex(group.creatives_data, function(item) {
                    return item.id == selectedItem.id;
                }) !== -1;
            });

            return group;
        }, this);
    }
});
