block('b-creative-list-filters')(
    def()(function() {
        var order = this.ctx.order || 'desc',
            orderItems = [
                { name: 'desc', text: iget2('b-creative-list-filters', 'snachala-novye', 'Сначала новые'), selected: order == 'desc' },
                { name: 'asc', text: iget2('b-creative-list-filters', 'snachala-starye', 'Сначала старые'), selected: order == 'asc' }
            ];

        return applyNext({
            order: order,
            orderItems: orderItems
        })
    }),

    js()(function() {
        return {
            filtersData: this.ctx.filtersData,
            modelData: {
                order: this.order,
                search: this.ctx.search,
                filters: this.ctx.filters
            }
        }
    }),

    elem('controls-panel').def()(function() {
        var elemMix = [{ block: 'b-creative-list-filters', elem: 'filter-elem' }];

        return applyCtx([
            { elem: 'search', mix: elemMix, search: this.ctx.search },
            {
                elem: 'filters',
                mix: elemMix,
                filters: this.ctx.filters,
                filtersData: this.ctx.filtersData
            },
            { elem: 'sort', mix: elemMix },
            { elem: 'apply-btn', mix: elemMix }
        ]);
    }),

    elem('filters').def()(function() {
        return applyCtx([
            {
                block: 'dropdown2',
                mods: { switcher: 'button', theme: 'normal', 'has-tick': 'yes', size: 's' },
                mix: [{
                    block: 'b-creative-list-filters',
                    elem: 'filters-chooser-dropdown'
                }].concat(this.ctx.mix),
                switcher: iget2('b-creative-list-filters', 'filtr', 'Фильтр'),
                popup: {
                    block: 'popup2',
                    zIndexGroupLevel: 35000,
                    content: {
                        block: 'b-creative-list-filters',
                        elem: 'filters-chooser-popup',
                        content: {
                            block: 'b-chooser',
                            mix: {
                                block: 'b-creative-list-filters',
                                elem: 'filters-chooser'
                            },
                            content: {
                                elem: 'wrap',
                                // У фильтров должен быть определенный порядок, задаем его тут и добавляем новые ключи
                                // если такие внезапно появятся
                                content: u._.union(
                                    ['theme', 'layout', 'size', 'campaigns', 'create_time', 'business_type'],
                                    Object.keys(this.ctx.filtersData)).map(function(filterId) {
                                        if (!(u._.get(this.ctx.filtersData, [filterId, 'values']) || []).length) return;

                                        var filterData = this.ctx.filtersData[filterId];

                                        return {
                                            elem: 'item',
                                            mix: {
                                                block: 'b-creative-list-filters',
                                                elem: 'filters-chooser-item'
                                            },
                                            js: { text: filterData.name, value: filterId },
                                            name: filterId,
                                            content: [
                                                filterData.name,
                                                {
                                                    block: 'icon',
                                                    mix: {
                                                        block: 'b-creative-list-filters',
                                                        elem: 'filters-chooser-item-arrow'
                                                    },
                                                    mods: { 'size-13': 'arrow-right' }
                                                }
                                            ]
                                        }
                                    }, this)
                            }
                        }
                    }
                }
            }

        ]);
    }),

    elem('sub-filter-content').content()(function() {
        var subFilters = this.ctx.subFilters || [],
            selected = this.ctx.selected;

        return {
            block: 'b-chooser',
            mix: {
                block: 'b-creative-list-filters',
                elem: 'sub-filters-chooser'
            },
            mods: {
                search: 'yes',
                multi: 'yes'
            },
            content: [
                {
                    elem: 'search',
                    hint: iget2('b-creative-list-filters', 'iskat-uslovie', 'Искать условие')
                },
                {
                    elem: 'wrap',
                    content: subFilters.map(function(filter) {
                        return {
                            elem: 'item',
                            elemMods: { selected: selected.indexOf(filter.value) !== -1 ? 'yes' : '' },
                            js: { text: filter.name, value: filter.value },
                            name: u.moment(filter.name).isValid() ?
                                u.moment(filter.value).format('YYYYMMDDHHmmss') :
                                filter.value,
                            content: filter.name
                        }
                    })
                },
                {
                    elem: 'not-found',
                    mix: { block: 'b-creative-list-filters', elem: 'not-found' },
                    content: iget2('b-creative-list-filters', 'nichego-ne-naydeno', 'Ничего не найдено')
                }
            ]
        };
    }),

    elem('sort').def()(function() {
        var orderItems = this.orderItems;

        return applyCtx({
            block: 'dropdown2',
            mods: { switcher: 'button', theme: 'normal', 'has-tick': 'yes', size: 's' },
            mix: (this.ctx.mix || []).concat({
                block: 'b-creative-list-filters',
                elem: 'filters-sort-chooser-dropdown'
            }),
            switcher: {
                block: 'button',
                mix: { block: 'b-creative-list-filters', elem: 'sort-chooser-switcher' },
                content: [
                    {
                        block: 'b-creative-list-filters',
                        elem: 'filters-sort-title',
                        content: iget2('b-creative-list-filters', 'sortirovka', 'Сортировка') + ':'
                    },
                    {
                        block: 'b-creative-list-filters',
                        elem: 'filters-sort-content',
                        content: u._.find(orderItems, function(item) {
                            return item.selected;
                        }).text
                    }
                ]
            },
            popup: {
                block: 'popup2',
                zIndexGroupLevel: 35000,
                content: {
                    block: 'b-creative-list-filters',
                    elem: 'filters-sort-chooser-popup',
                    content: {
                        block: 'b-chooser',
                        mix: {
                            block: 'b-creative-list-filters',
                            elem: 'filters-sort-chooser'
                        },
                        content: {
                            elem: 'wrap',
                            content: orderItems.map(function(item) {
                                return {
                                    elem: 'item',
                                    elemMods: { selected: item.selected ? 'yes' : '' },
                                    js: { text: item.text },
                                    name: item.name,
                                    content: item.text
                                }
                            })
                        }
                    }
                }
            }
        });
    }),

    elem('filters-view').content()(function() {
        var filtersData = this.ctx.filtersData,
            filters = this.ctx.filters,
            filterTextsByType = filters.reduce(function(acc, data) {
                acc[data.filter] = u['b-creative-list-filters'].getFilterTextsByType(filtersData, filters, data.filter);

                return acc;
            }, {}),
            filtersBadges = [];

        filtersBadges.push(Object.keys(filterTextsByType).map(function(type) {
            return {
                block: 'b-creative-list-filters',
                elem: 'filter-view',
                elemMods: { 'filter-type': type },
                content: [
                    {
                        block: 'button2',
                        title: filterTextsByType[type].titleText,
                        mods: { theme: 'normal', size: 's', pin: 'round-brick', action: 'filters-badge' },
                        js: { filterType: type },
                        content: {
                            elem: 'text',
                            content: [
                                {
                                    block: 'b-creative-list-filters',
                                    elem: 'filter-title',
                                    content: filterTextsByType[type].name + ':'
                                },
                                {
                                    block: 'b-creative-list-filters',
                                    elem: 'filter-text',
                                    content: filterTextsByType[type].badgeText
                                }
                            ]
                        }
                    },
                    {
                        block: 'button2',
                        mods: { theme: 'normal', size: 's', pin: 'clear-round', action: 'filter-delete' },
                        js: { filterType: type },
                        content: {
                            block: 'b-creative-list-filters',
                            elem: 'filter-delete',
                            content: {
                                block: 'icon',
                                mix: { block: 'button2', elem: 'icon' },
                                mods: { 'size-10': 'cross' }
                            }
                        }
                    }
                ]
            }
        }));

        return [{ elem: 'filters-view-title', content: iget2('b-creative-list-filters', 'filtr', 'Фильтр') }].concat(filtersBadges);
    }),

    elem('search').content()(function() {
        return {
            block: 'input',
            mix: [
                { block: 'b-creative-list-filters', elem: 'search-control' },
                { block: 'b-creative-list-filters', elem: 'filters-elem' },
                {
                    block: 'b-creative-list-filters',
                    elem: 'model-field',
                    js: {
                        name: 'search',
                        type: 'input'
                    }
                }
            ],
            value: this.ctx.search,
            placeholder: iget2('b-creative-list-filters', 'nayti-po-nomeru-nazvaniyu', 'Найти по номеру/названию'),
            content: [
                {
                    elem: 'control'
                }
            ]
        };
    }),

    elem('apply-btn').def()(function() {
        var mix = this.ctx.mix || [];

        mix.push({ block: 'b-creative-list-filters', elem: 'apply-btn' });

        return applyCtx({
            block: 'button',
            mods: { theme: 'action', disabled: 'yes' },
            mix: mix,
            content: iget2('b-creative-list-filters', 'primenit', 'Применить')
        });
    })
);
