BEM.DOM.decl({ block: 'b-creative-list-filters', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
            this._filtersData = this.params.filtersData;

            if (this.findBlockOutside('popup')) {
                this._outsidePopup = this.findBlockOutside('popup');
            }

            this
                ._initContent()
                ._initEvents();
        }
    },

    /**
     * Если данные блок открывается внутри попапа, то необходимо добавить ему в child
     * все popup2 из фильтров/сортировки
     */
    _outsidePopup: null,

    /**
     * Возвращает данные панели фильтров
     * @returns {Object}
     */
    getValue: function() {
        var filtersData = this.model.toJSON();

        filtersData.filters = [].concat(filtersData.filters);

        return filtersData;
    },

    /**
     * Удаляем блок и отписываемся от всех его событий
     * @returns {*}
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Инициализируем содержимое блока
     * @returns {BEM}
     * @private
     */
    _initContent: function() {
        u.graspSelf.call(this, {
            _sortDropdown: 'dropdown2 on filters-sort-chooser-dropdown',
            _filtersDropdown: 'dropdown2 on filters-chooser-dropdown',
            _sortChooser: 'b-chooser on filters-sort-chooser',
            _filterChooser: 'b-chooser on filters-chooser',
            _applyButton: 'button on apply-btn'
        });

        if (this._outsidePopup) {
            var sortDropdownPopup = this._sortDropdown.getPopup(),
                filtersDropdownPopup = this._filtersDropdown.getPopup();

            sortDropdownPopup
                .on('beforeClose', function() {
                    this._outsidePopup.removeChild(sortDropdownPopup);
                }, this)
                .on('beforeOpen', function() {
                    this._outsidePopup.addChild(sortDropdownPopup);
                }, this);

            filtersDropdownPopup
                .on('beforeClose', function() {
                    this._outsidePopup.removeChild(filtersDropdownPopup);
                }, this)
                .on('beforeOpen', function() {
                    this._outsidePopup.addChild(filtersDropdownPopup);
                }, this);
        }

        return this;
    },

    /**
     * Возвращаем массив с данными по дочерним фильтрам по имени родителя
     * @param {String} id
     * @returns {Array}
     * @private
     */
    _getSubFiltersForFilter: function(id) {
        return this._filtersData[id] && this._filtersData[id].values || []
    },

    /**
     * Инициализируем основные события на блоке
     * @returns {BEM}
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._subscriptionManager
            .on(this._applyButton, 'click', this._onApplyBtnClick, this)
            .on(this._sortChooser, 'change', this._onSortChooserChange, this)
            .on(this._filterChooser, 'change', this._onFilterChooserChange, this)
            .on(this.model, 'change', function() {
                this._applyButton.setMod('disabled', this.model.isChanged() ? '' : 'yes');
            }, this);

        return this;
    },

    /**
     * Изменение подя filters у модели
     * @returns {BEM}
     * @private
     */
    _onSelectedFiltersChange: function() {
        if (this._subFilterPopup && this._subFilterPopup.getMod('from') == 'badge' &&
            this._subFilterPopup.getMod('visible') == 'yes') {

            this._updateBadgeTexts();

            // перерисовываем попап чтобы при "перепрыгивании" бэйджа на другую строку подстраиваться под него
            this._subFilterPopup.redraw();
        } else if (u['b-creative-list-filters'].extractBadgesFilters(this.model.get('filters'))) {
            BEM.DOM.replace(this.findElem('filters-view'), BEMHTML.apply({
                block: 'b-creative-list-filters',
                elem: 'filters-view',
                filtersData: this._filtersData,
                filters: u['b-creative-list-filters'].extractBadgesFilters(this.model.get('filters'))
            }));
        }

        return this;
    },

    /**
     * Обновляет текста в бэйджике (title и текст в кнопке)
     * @returns {BEM}
     * @private
     */
    _updateBadgeTexts: function() {
        if (!this._subFilterPopup) return this;

        var filtersType = this._subFilterPopup.getMod('filter-type'),
            filtersBadge = this.findElem('filter-view', 'filter-type', filtersType),
            button = this.findBlockInside(
                filtersBadge,
                { block: 'button2', modName: 'action', modVal: 'filters-badge' }
            ),
            badgeText = this.findElem(filtersBadge, 'filter-text'),
            texts = u['b-creative-list-filters'].getFilterTextsByType(
                this._filtersData,
                this.model.get('filters'), filtersType
            );

        button.domElem.attr('title', texts.titleText);
        badgeText.text(texts.badgeText);

        return this;
    },

    /**
     * Нажатие на кнопку "Применить"
     * @private
     */
    _onApplyBtnClick: function() {
        this.trigger('change', { value: this.getValue() });

        this.model.fix();
    },

    /**
     * В меню выбора фильтра выбран элемент
     * @param {Object} e
     * @param {Object} data
     * @private
     */
    _onFilterChooserChange: function(e, data) {
        if (data.selected) {
            this._getSubFilterPopup(data.value, 'filter-chooser')
                .setAnchor(this._filterChooser.elemInstance('item', 'name', data.name).domElem)
                .setMod('visible', 'yes');

            //снимаем выделеение в выбранного на текущий момент пункта
            this._filterChooser.uncheck(data.name);
        }
    },

    /**
     * Отрисовывает и возвращает попап с сабфильтрами для данного фильтра
     * @param {String} filterId Тип фитльра
     * @param {String} from тип инициатора открытия попапа (фильтры/бэйджи)
     * @param {Array} [directions] Направление открытия
     * @returns {Object}
     * @private
     */
    _getSubFilterPopup: function(filterId, from, directions) {
        if (!this._subFilterPopup) {
            this._subFilterPopup = $(BEMHTML.apply({
                block: 'popup2',
                zIndexGroupLevel: 35000,
                directions: directions || ['right-top'],
                mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' }
            })).appendTo(BEM.blocks['b-page'].getInstance().domElem).bem('popup2');
        }

        this._subFilterPopup.setMod('from', from).setMod('filter-type', filterId);

        if (directions) {
            this._subFilterPopup.params.directions = directions;
        } else {
            this._subFilterPopup.params.directions = ['right-top'];
        }

        var subFilters = this._getSubFiltersForFilter(filterId);

        this._subFilterChooser && this._subscriptionManager.un(this._subFilterChooser, 'change');

        this._subFilterPopup.setContent(BEMHTML.apply({
            block: 'b-creative-list-filters',
            elem: 'sub-filter-content',
            selected: u['b-creative-list-filters'].getValuesForFilter([].concat(this.model.get('filters')), filterId),
            subFilters: subFilters
        }));

        this._subFilterChooser = this._subFilterPopup.findBlockInside('b-chooser');

        this._subscriptionManager
            .on(this._subFilterChooser, 'change', function(e, data) {
                this._toggleFilter({ filter: filterId, value: data.value }, data.selected);

                this._onSelectedFiltersChange();
            }, this)
            .on(this._subFilterPopup, 'beforeClose', function() {
                if (this._outsidePopup) {
                    this._outsidePopup.removeChild(this._subFilterPopup);
                }
                // after нужен чтобы событие отбработало после закрытия
                this.afterCurrentEvent(function() {
                    // Меняем якорь при закрытии чтобы попап не задестрактился когда удалится бэйдж
                    this._subFilterPopup.setAnchor(BEM.blocks['b-page'].getInstance().domElem);

                    // При закрытии вызываем обработчик чтобы удалить пустые бэйджи
                    this._onSelectedFiltersChange();
                }, this);
            }, this)
            .on(this._subFilterPopup, 'beforeOpen', function() {
                if (this._outsidePopup) {
                    this._outsidePopup.addChild(this._subFilterPopup);
                }
            }, this);

        return this._subFilterPopup;
    },

    /**
     * Добавляет/удаляет выбранный фильтр в модель/из модели
     * @param {Object} filter
     * @param {String} filter.filter
     * @param {String} filter.name
     * @param {Boolean} selected
     * @private
     */
    _toggleFilter: function(filter, selected) {
        var filters = this.model.get('filters'),
            index = u['b-creative-list-filters'].findFilterIndex(filters, filter);

        selected && (index == -1) && filters.push(filter);
        !selected && (index !== -1) && filters.splice(index, 1);

        this._toggleModHasFilters();
    },

    /**
     * Удаляет все выбранные фильтры по типу фильтра
     * @param {String} type тип фильтра
     * @private
     */
    _removeFiltersByType: function(type) {
        this.model.update({
            filters: this.model.get('filters').reduce(function(acc, filter) {
                if (filter.filter != type) {
                    acc.push(filter);
                }

                return acc;
            }, [])
        });

        // Если в момент удаления блока открыт попап - закрываем его чтобы попап не задестрактился
        if (this._subFilterPopup) {
            this._subFilterPopup.delMod('visible');
        }

        // Если мы внутри попапа - after нужен чтобы элемент оставался
        // т.к. при дестракте мы удаляем элемент из DOM-дерева и в методе _isRelatedNode выходит что элемента внутри нет.
        // DIRECT-63814: 9500
        this.afterCurrentEvent(function() {
            BEM.DOM.destruct(this.findElem('filter-view', 'filter-type', type));
            this._toggleModHasFilters();
        });
    },

    /**
     * Логика установки модификатора наличия фильтров для показа/скрытия бэйджев
     * @returns {BEM}
     * @private
     */
    _toggleModHasFilters: function() {
        if (this._subFilterPopup && this._subFilterPopup.getMod('visible') == 'yes' &&
            this._subFilterPopup.getMod('from') == 'badge') {

            this._subFilterPopup.onFirst('beforeClose', function() {
                this.setMod('has-filters', this.model.get('filters').length ? 'yes' : '');
            }, this);
        } else {
            this.setMod('has-filters', this.model.get('filters').length ? 'yes' : '');
        }

        return this;
    },

    /**
     * Обработкик нажатия на бэйдж, открывает попап с фильтрами по типу фильтра
     * @param {BEM} badge блок кнопки бэйджика
     * @private
     */
    _editFiltersByType: function(badge) {
        var type = badge.params.filterType;

        this._getSubFilterPopup(type, 'badge', ['bottom-left'])
            .setAnchor(badge)
            .setMod('visible', 'yes');
    },

    /**
     * Изменился контрол выбора сортировки
     * @param {Object} e
     * @param {Object} data
     * @private
     */
    _onSortChooserChange: function(e, data) {
        if (data.selected) {
            this._sortDropdown.getPopup().delMod('visible');

            this.model.set('order', data.name);

            BEM.DOM.update(this.elem('filters-sort-content'), data.text);
        }
    },

    /**
     * Общий обработчик нажатия блока кнопки
     * В зависимости от модификатора action вызывается необходимый метод
     * @param {Event} e
     * @private
     */
    _onButtonClick: function(e) {
        switch (e.block.getMod('action')) {
            case 'filter-delete':
                this._removeFiltersByType(e.block.params.filterType);
                break;
            case 'filters-badge':
                this._editFiltersByType(e.block);
                break;
        }
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button2', this.prototype._onButtonClick);

        return false;
    }
});
