u.register({
    'b-creative-list-filters': {
        /**
         * Возвращает индекс currentFilter в массиве filters
         * @param {Object[]} filters выбранные фильтры
         * @param {Object} currentFilter текущий фильтр
         * @returns {Number}
         */
        findFilterIndex: function(filters, currentFilter) {
            return u._.findIndex(filters, function(filter) {
                return u._.isEqual(currentFilter, filter);
            });
        },

        /**
         * Возвращает массив уже выбранных значений для фильтра filterId
         * @param {Object[]} filters выбранные фильтры
         * @param {String} filterId тип фильтра
         * @returns {Array}
         */
        getValuesForFilter: function(filters, filterId) {
            var selected = [];

            filters.forEach(function(filter) {
                if (filter.filter === filterId) selected.push(filter.value);
            });

            return selected;
        },

        /**
         * Формирует объект с текстами для фильтра по его типу
         * @param {Object[]} filtersData данные всех фильтров
         * @param {Object[]} filters выбранные фильтры
         * @param {String} filterId тип фильтра
         * @returns {{name: (String), titleText: (String), badgeText: (String)}}
         */
        getFilterTextsByType: function(filtersData, filters, filterId) {
            var fullTexts = [],
                filterTexts = {
                    name: filtersData[filterId].name,
                    titleText: iget2('b-creative-list-filters', 'filtry-ne-zadany', 'Фильтры не заданы'),
                    badgeText: iget2('b-creative-list-filters', 'filtry-ne-zadany', 'Фильтры не заданы')
                };

            filters.forEach(function(filter) {
                var filterData = u._.find(filtersData[filterId].values, { value: filter.value });

                if (filterData && filterData.name) {
                    fullTexts.push(filterData.name);
                }
            });

            if (fullTexts.length) {
                filterTexts['titleText'] = fullTexts.join(', ');
                filterTexts['badgeText'] = u.hellipCut(fullTexts.map(function(text) {
                    return u.hellipCut(text, 15, u.escapeHTML);
                }).join(', '), 60, u.escapeHTML);
            }

            return filterTexts;
        },

        /**
         * Возвращаем массив фильтров по которым строятся бэйджи
         * @param {Object[]} filters выбранные фильтры
         * @returns {Array}
         */
        extractBadgesFilters: function(filters) {
            var badgesFilters = [];

            (filters || []).forEach(function(filter) {
                // Если это фильтр по статусу - пропускаем его
                if (filter.filter != 'status_moderate') {
                    badgesFilters.push(filter);
                }
            });

            return badgesFilters;
        },

        /**
         * Возвращаем массив фильтров отвечающих за статус модерации
         * @param {Object[]} filters выбранные фильтры
         * @returns {Array}
         */
        extractStatusFilters: function(filters) {
            var badgesFilters = [];

            (filters || []).forEach(function(filter) {
                // Если это фильтр не по статусу - пропускаем его
                if (filter.filter == 'status_moderate') {
                    badgesFilters.push(filter);
                }
            });

            return badgesFilters;
        }
    }
});
