block('b-creative-list-status-tabs')(
    js()(function() {
        return true;
    }),

    content()(function() {
        var statusData = this.ctx.statusData || {},
            activeTab = this.ctx.activeTab && statusData[this.ctx.activeTab] ? this.ctx.activeTab : 'all',
            tabsData = [
                {
                    title: iget2('b-creative-list-status-tabs', 'prinyatye', 'Принятые'),
                    name: 'accepted',
                    count: statusData.accepted
                },
                {
                    title: iget2('b-creative-list-status-tabs', 'na-moderacii', 'На модерации'),
                    name: 'wait',
                    count: statusData.wait
                },
                {
                    title: iget2('b-creative-list-status-tabs', 'otklonennye', 'Отклоненные'),
                    name: 'rejected',
                    count: statusData.rejected
                },
                {
                    title: iget2('b-creative-list-status-tabs', 'chernoviki', 'Черновики'),
                    name: 'draft',
                    count: statusData.draft
                },
                {
                    title: iget2('b-creative-list-status-tabs', 'vse', 'Все'),
                    name: 'all',
                    count: statusData.all
                }
            ];

        return {
            block: 'tabs-menu',
            mix: {
                block: 'b-creative-list-status-tabs',
                elem: 'tabs-menu'
            },
            mods: { size: 's', theme: 'border-bottom', layout: 'horiz' },
            content: tabsData.map(function(tabData) {
                return {
                    elem: 'tab',
                    mix: {
                        block: 'b-creative-list-status-tabs',
                        elem: 'tab',
                        elemMods: { val: tabData.name }
                    },
                    elemMods: {
                        interactive: 'yes',
                        disabled: tabData.count && tabData.count > 0 ? '' : 'yes',
                        active: tabData.name == activeTab ? 'yes' : ''
                    },
                    content: [
                        {
                            block: 'link',
                            mix: {
                                block: 'b-creative-list-status-tabs',
                                elem: 'link'
                            },
                            content: tabData.title
                        },
                        {
                            block: 'b-creative-list-status-tabs',
                            elem: 'count',
                            content: tabData.count
                        }
                    ]
                }
            })
        }
    })
);
