block('b-creative-wrapper')(
    js()(function() {
        var ctx = this.ctx,
            modelData = ctx.modelData || {};

        modelData.isGroup = this.mods.view == 'groups';

        return {
            modelName: 'b-creative-wrapper',
            modelData: modelData,
            options: ctx.options || {}
        }
    }),

    content()(function() {
        var options = this.ctx.options || {};

        return [
            {
                elem: 'content-container',
                content: [
                    !!options.hasStatusTabs && { elem: 'status-tabs-container' },
                    !!options.hasFilters && { elem: 'filters-container' },
                    { elem: 'items-container' },
                    { elem: 'show-more-btn' }
                ]
            },
            {
                block: 'b-paranja',
                mods: { visible: 'yes' },
                mix: {
                    block: 'b-creative-wrapper',
                    elem: 'paranja'
                }
            }
        ]
    }),

    elem('items').def()(function() {
        var ctx = this.ctx;

        return applyCtx({
            block: u['b-creative-wrapper'].getItemsListBlockName(ctx.isGroup),
            mix: { block: 'b-creative-wrapper', elem: 'items' },
            // fromChanged - означает что блок будет формироваться из данных которые изменялись пользователем ранее
            fromChanged: ctx.fromChanged,
            otherIds: ctx.otherIds,
            controlsType: ctx.controlsType,
            selectedItemsIds: ctx.selectedItemsIds,
            items: ctx.items,
            filters: ctx.filters,
            search: ctx.search,
            //нужно только в попапе креативов по группе
            groupId: ctx.groupId
        });
    }),

    elem('status-tabs').def()(function() {
        return applyCtx({
            block: 'b-creative-list-status-tabs',
            mix: { block: 'b-creative-wrapper', elem: 'status-tabs' },
            activeTab: this.ctx.activeTab,
            statusData: this.ctx.statusData
        })
    }),

    elem('filters').def()(function() {
        var badgesFilters = u['b-creative-list-filters'].extractBadgesFilters(this.ctx.filters);

        return applyCtx({
            block: 'b-creative-list-filters',
            mods: { 'has-filters': badgesFilters.length ? 'yes' : '' },
            mix: { block: 'b-creative-wrapper', elem: 'filters' },
            filters: this.ctx.filters,
            search: this.ctx.search,
            order: this.ctx.order,
            filtersData: this.ctx.filtersData,
            content: [
                {
                    elem: 'wrapper',
                    content: [
                        {
                            elem: 'controls-panel',
                            filters: this.ctx.filters,
                            search: this.ctx.search,
                            order: this.ctx.order,
                            filtersData: this.ctx.filtersData
                        },
                        !!this.ctx.options.hasViewSwitcher && {
                            block: 'b-switcher-group-list-view',
                            mix: { block: 'b-creative-wrapper', elem: 'view-switcher' },
                            value: this.ctx.isGroup ? 'group' : 'list'
                        }
                    ]
                },
                {
                    block: 'b-creative-list-filters',
                    elem: 'filters-view',
                    filters: badgesFilters,
                    filtersData: this.ctx.filtersData
                }
            ]
        })
    }),

    elem('show-more-btn').def()(function() {
        return applyCtx({
            block: 'button',
            mix: { block: 'b-creative-wrapper', elem: 'show-more-btn' },
            content: iget2('b-creative-wrapper', 'pokazat-eshche', 'Показать еще')
        });
    })
);
