BEM.DOM.decl('b-creative-wrapper', {
    onSetMod: {
        js: function() {
            this._viewModel = BEM.MODEL.create(this.params.modelName, this.params.modelData);
            //информация о том, какие фильтры нужно показывать
            this._options = this.params.options;

            this._paranja = this.findBlockOn('paranja', 'b-paranja');

            this._initCommonEvents();

            this.fetchDataAndRenderBlock();
        }
    },

    /**
     * Изменился ли список выбранных элементов
     * @returns {Boolean}
     */
    isSelectedChanged: function() {
        return this._itemsListBlock ? this._itemsListBlock.isSelectedChanged() : false;
    },

    /**
     * Запрашивает данные с сервера и перерисовывает весь блок
     * @private
     */
    fetchDataAndRenderBlock: function() {
        return this._fetchData().done(function(data) {
            this._updateItemsList(data, true);

            this._renderStatusTabs();
            this._renderFilters();
        }.bind(this))
    },

    /**
     * Возвращает массив с выбранными креативами
     * @returns {Number[]}
     */
    getSelectedIds: function() {
        return this._itemsListBlock ? this._itemsListBlock.getSelectedIds() : [];
    },

    /**
     * Возвращает строку с текстом про выбранное число баннеров
     * @returns {String}
     */
    getSelectedCountMessage: function() {
        var length = this.getSelectedIds().length;

        return length ? u.pluralizeWord([iget2('b-creative-wrapper', 'vybran-s-kreativ', 'Выбран {foo} креатив', {
            foo: length
        }), iget2('b-creative-wrapper', 'vybrano-s-kreativa', 'Выбрано {foo} креатива', {
            foo: length
        }), iget2('b-creative-wrapper', 'vybrano-s-kreativov', 'Выбрано {foo} креативов', {
            foo: length
        })], length) : '';
    },

    /**
     * Возвращает список выбранных креативов
     * @returns {Promise}
     */
    getSelectedCreatives: function() {
        var selectedIds = this.getSelectedIds().map(function(data) { return data.id });

        return BEM.blocks['i-creative-request'].fetch(this._viewModel.getDataToAjaxRequestByIds(selectedIds))
            .fail(this._fetchDataFail.bind(this));

    },

    /**
     * Удаляет блок и модель
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Инициализируем основные события
     * @private
     */
    _initCommonEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._subscriptionManager.on(this._viewModel, 'otherIds', 'change', this._switchHasMoreBtn, this);
        this._subscriptionManager.on(this._viewModel, 'shownGroupsCount', 'change', this._switchHasMoreBtn, this);

        this._showMoreBtn = this.findBlockOn('show-more-btn', 'button');
        this._showMoreBtn && this._subscriptionManager.on(this._showMoreBtn, 'click', this._onShowMoreClick, this);
    },

    /**
     * Обновляет серверными данными список групп/креативов
     * @param {Object} data
     * @param {Boolean} [needRenderList] нужно перерисовать весь лист целиком
     * @returns {BEM}
     * @private
     */
    _updateItemsList: function(data, needRenderList) {
        var isGroup = this._viewModel.get('isGroup'),
            items = data[isGroup ? 'groups' : 'creatives'];

        if (isGroup) {
            items = items.map(function(item) {
                return u['b-creative-group'].prepareServerData(item);
            });
        }

        if (needRenderList) {
            //перерисовываем список
            this._renderListBlock(items);
        } else {
            //добавляем item-ы в существующий список
            this._itemsListBlock.addItems(items, this._viewModel.get('otherIds'))
        }

        return this;
    },

    /**
     *
     * @returns {Promise}
     * @private
     */
    _fetchData: function() {
        this._paranja.setMod('visible', 'yes');

        this.trigger('data-loading:start');

        return BEM.blocks['i-creative-request'].fetch(this._viewModel.getDataToAjaxRequest())
            .done(this._fetchDataSuccess.bind(this))
            .fail(this._fetchDataFail.bind(this));
    },

    /**
     * Ошибка запроса данных
     * @param {String} error
     * @private
     */
    _fetchDataFail: function(error) {
        this.trigger('data-loading:end');

        this._paranja.delMod('visible');

        BEM.blocks['b-confirm'].alert(error);
    },

    /**
     * Данные для отрисовки блока (табы + фильтры + список) получены
     * @param {Object} data
     * @private
     */
    _fetchDataSuccess: function(data) {
        //на странице создание/редактирования группы не показываем фильтр по типу бизнеса
        if (this._options.skipBusinessTypeFilter) {
            var filters = this._viewModel.toJSON()['filters'],
                businessTypeIndex = u._.findIndex(filters, function(i) { return i.filter == 'business_type'; });

            // Фильтры по типу бизнеса которые мы удаляем, складываем отдельно, т.к. они нужны будут при последующих запросах
            if (filters[businessTypeIndex] && data.filters.business_type) {
                this._viewModel.set('hiddenFilters', [filters[businessTypeIndex]]);

                this._viewModel.get('filters').splice(businessTypeIndex, 1);
                delete data.filters.business_type;
            }
        }

        this._viewModel.update({
            otherIds: data.other_ids.map(function(data) {
                if (!data.creative_group_id) data.creative_group_id = '0';

                return data;
            }),
            groupsTotalCount: data.total_count,
            shownGroupsCount: data.total_count > (data.per_page * (data.page || data.current_page)),
            shownCreativeIds: data.creatives,
            statusData: data.status,
            filtersData: data.filters
        });

        this._paranja.delMod('visible');

        this.trigger('data-loading:end');

        return true;
    },

    /**
     * Перерисовывает список креативов/групп
     * @param {Array} items
     * @returns {BEM}
     * @private
     */
    _renderListBlock: function(items) {
        BEM.DOM.update(this.elem('items-container'), BEMHTML.apply({
            block: 'b-creative-wrapper',
            elem: 'items',
            fromChanged: this.isSelectedChanged(),
            controlsType: this.getMod('controls-type'),
            isGroup: this._viewModel.get('isGroup'),
            groupId: this._viewModel.get('groupId'),
            otherIds: this._viewModel.get('otherIds'),
            selectedItemsIds: this._viewModel.get('selectedItemsIds'),
            filters: this._viewModel.get('filters'),
            search: this._viewModel.get('search'),
            items: items
        }));

        return this._initListBlock();
    },

    /**
     * Инициализируем блок с группами/списками креативов  и навешиваем на него все нужные события
     * @returns {_initListBlock}
     * @private
     */
    _initListBlock: function() {
        this._itemsListBlock = this.findBlockOn(
            'items',
            u['b-creative-wrapper'].getItemsListBlockName(this._viewModel.get('isGroup'))
        );

        this._subscriptionManager
            .on(this._itemsListBlock, 'selectedChanged', function(e, data) {
                this._viewModel.set('selectedItemsIds', data.selected);

                this.trigger('selectedChanged', data);
            }, this)
            .on(this._itemsListBlock, 'editCreatives', function(e, data) {
                this.trigger('editCreatives', data);
            }, this);

        this.trigger('selectedChanged', this._viewModel.get('selectedItemsIds'));

        return this;
    },

    /**
     * Переключает модификатор на блок есть еще данные для загрузки/нет данных для загрузки
     * @private
     */
    _switchHasMoreBtn: function() {
        var otherIds = this._viewModel.get('otherIds');

        if (this._viewModel.get('isGroup')) {
            this.setMod('has-more-data', this._viewModel.get('shownGroupsCount') ? 'yes' : '');
        } else {
            this.setMod('has-more-data', otherIds && otherIds.length ? 'yes' : '');
        }
    },

    /**
     * Отрисовываем табы "Переключение по статусам"
     * @private
     */
    _renderStatusTabs: function() {
        if (!this._options.hasStatusTabs) return;

        this._statusTabs && this._subscriptionManager.un(this._statusTabs, 'change');

        BEM.DOM.update(this.elem('status-tabs-container'), BEMHTML.apply({
            block: 'b-creative-wrapper',
            elem: 'status-tabs',
            activeTab: u['b-creative-wrapper'].getActiveTab(this._viewModel.get('filters')),
            statusData: this._viewModel.get('statusData')
        }));

        this._statusTabs = this.findBlockOn('status-tabs', 'b-creative-list-status-tabs');
        this._statusTabs && this._subscriptionManager.on(this._statusTabs, 'change', this._onStatusChange, this);
    },

    /**
     * Отрисовываем фильтры
     * @private
     */
    _renderFilters: function() {
        if (!this._options.hasFilters) return;

        BEM.DOM.update(this.elem('filters-container'), BEMHTML.apply({
            block: 'b-creative-wrapper',
            elem: 'filters',
            isGroup: this._viewModel.get('isGroup'),
            search: this._viewModel.get('search'),
            order: this._viewModel.get('order'),
            filtersData: this._viewModel.get('filtersData'),
            filters: this._viewModel.get('filters'),
            options: this._options
        }));

        this._filtersControl = this.findBlockOn('filters', 'b-creative-list-filters');
        this._filtersControl && this._subscriptionManager.on(
            this._filtersControl,
            'change',
            this._onFiltersChange,
            this
        );

        //переключатель вида находится внутри блока с фильтрами
        this._viewSwitcher = this.findBlockOn('view-switcher', 'b-switcher-group-list-view');
        this._viewSwitcher && this._subscriptionManager.on(this._viewSwitcher, 'change', this._onViewChange, this);

    },

    /**
     * Переключением между табами статусов
     * @param {Object} e
     * @param {Object} data
     * @private
     */
    _onStatusChange: function(e, data) {
        this._viewModel.setNewStatus(data.value);

        this._fetchData().done(function(data) {
            this._updateItemsList(data, true);
            this._renderFilters();
        }.bind(this));
    },

    /**
     * Переключился переключатель Группы/Список
     * @param {Object} e
     * @param {Object} data
     * @private
     */
    _onViewChange: function(e, data) {
        this._viewModel.switchView();

        this.setMod('view', this._viewModel.get('isGroup') ? 'groups' : 'list');

        this.fetchDataAndRenderBlock();
    },

    /**
     * Изменение фильтров
     * @param {Object} e
     * @param {Object} data
     * @private
     */
    _onFiltersChange: function(e, data) {
        var value = data.value,
            statusFilters = u['b-creative-list-filters'].extractStatusFilters(this._viewModel.toJSON().filters);

        this._viewModel.update({
            filters: statusFilters.concat(value.filters),
            selectedItemsIds: [],
            search: value.search,
            page: 1,
            order: value.order
        });

        this.fetchDataAndRenderBlock();
    },

    /**
     * Клик по кнопке "Показать еще"
     * @private
     */
    _onShowMoreClick: function() {
        this._viewModel.incrementPage();

        this._fetchData().done(function(data) {
            this._updateItemsList(data);
        }.bind(this));
    }
}, {
});
