u.register({
    'b-creative-wrapper': {
        /**
         * Возвращает имя блока, который будет использоваться для отрисовки креативов/групп креативов
         * @param {Boolean} isGroup
         * @returns {String}
         */
        getItemsListBlockName: function(isGroup) {
            return isGroup ? 'b-creative-groups-list' : 'b-dynamic-media-creative-list';
        },

        /**
         * Получаем активный таб из списка фильтров
         * @param {Object[]} filters массив фильтров
         */
        getActiveTab: function(filters) {
            var activeTab = 'all';

            filters.forEach(function(filter) {
                if (filter.filter == 'status_moderate') {
                    activeTab = filter.value;
                }
            });

            return {
                Yes: 'accepted',
                No: 'rejected',
                New: 'draft',
                Wait: 'wait',
                all: ''
            }[activeTab];
        }
    }
});
