BEM.MODEL.decl('b-creative-wrapper', {
    isGroup: 'boolean',

    //число баннеров/групп на страницу
    perPage: {
        type: 'number',
        default: 20
    },
    //количество страниц с баннерами/группами, которые загружены на текущий момент
    page: {
        type: 'number',
        default: 1
    },

    //строка поиска по креативам
    search: 'string',

    //порядок сортировки
    order: {
        type: 'enum',
        enum: ['asc', 'desc'],
        default: 'desc'
    },

    //примененные фильтры
    filters: 'array',

    //примененные фильтры которые не отображаются
    hiddenFilters: {
        type: 'array',
        default: []
    },

    //данные про все фильтры
    filtersData: 'object',

    //табы со статусами
    //типа object для полей у нас нету - но любой неопределенный тип по умолчанию превращается в объект
    statusData: 'object',

    currentStatus: {
        type: 'enum',
        enum: ['accepted', 'wait', 'draft', 'rejected', 'all'],
        default: 'all'
    },

    //id еще не загруженных групп креативов / креативов
    otherIds: {
        type: 'array'
    },

    //id выбранной группы
    groupId: 'string',

    //Сколько всего групп
    groupsTotalCount: {
        type: 'number',
        default: 0
    },

    //Сколько групп показано сейчас
    shownGroupsCount: {
        type: 'boolean',
        default: false,
        dependsFrom: ['groupsTotalCount', 'perPage', 'page'],
        calculate: function() {
            var groupsShown = this.get('perPage') * this.get('page');

            return this.get('groupsTotalCount') > groupsShown;
        }
    },

    //список выбранных креативов
    //для групп креативов список состоит из конкатенации выбранных в каждой группе креативов
    selectedItemsIds: 'array',

    excludeCreativeIds: 'array',

    leadCreativeId: 'string'

}, {
    /**
     * Устанавливаем новый статус для выборки креативов и сбрасываем все выборки/фильтрации
     * @param {'accepted'|'rejected'|'draft'|'wait'|'all'} status
     */
    setNewStatus: function(status) {
        // 'Yes|No|Wait|New' > Принятые|Отклоненные|На модерации|Черновики
        var serverFilterStatus = {
            accepted: 'Yes',
            rejected: 'No',
            draft: 'New',
            wait: 'Wait'
        }[status];

        this.update({
            page: 1,
            currentStatus: status,
            selectedItemsIds: [],
            filters: status !== 'all' ? [{ filter: 'status_moderate', value: serverFilterStatus }] : []
        });
    },

    /**
     * Переключает вид группа/список, сбрасывая при этом все настройки
     */
    switchView: function() {
        this.update({
            isGroup: !this.get('isGroup'),
            page: 1
        });
    },

    /**
     * Увеличивает число загруженных страниц на 1
     */
    incrementPage: function() {
        this.set('page', this.get('page') + 1);
    },

    /**
     *
     * На основании данных модели формируем данные для аякс-запроса на сервер
     * @returns {{sort: String, order: String, json_filter: Object, group: number, search: String, page: Number, per_page: Number, leadCreativeId: String, exclude_creative_ids: string, status_moderate: String}}
     */
    getDataToAjaxRequest: function() {
        var data = this.toJSON();

        return {
            sort: 'id',
            order: data.order,
            json_filter: JSON.stringify([].concat(data.filters, data.hiddenFilters)),
            group: data.isGroup ? 1 : 0,
            group_id: data.groupId,
            search: data.search,
            page: data.page,
            per_page: data.perPage,
            lead_creative_id: data.leadCreativeId,
            exclude_creative_ids: (data.excludeCreativeIds || []).join(','),
            status_moderate: this._prepareStatus(data.currentStatus)
        }
    },

    /**
     * Формирует запрос за данными по конкретным id
     * @param {Array} ids
     * @returns {{sort: 'id', order: String, json_filter: Object, per_page: 50, page: 1}}
     */
    getDataToAjaxRequestByIds: function(ids) {
        var data = this.toJSON();

        return {
            sort: 'id',
            order: data.order,
            json_filter: JSON.stringify([{ filter: 'id', value: ids }]),
            //мы не можем добавить больше 50 баннеров, по этому не грузим больше 50
            per_page: 50,
            page: 1
        }
    },

    /**
     * Переводим статус креатива из клиентского "читабельного" формата в формат, который понимает сервер
     * @param {'accepted'|'rejected'|'draft'|'wait'|'all'} status
     * @returns {'Yes'|'No'|'Wait'|New|''}
     * @private
     */
    _prepareStatus: function(status) {
        return {
            accepted: 'Yes',
            rejected: 'No',
            draft: 'New',
            wait: 'Wait',
            all: ''
        }[status];
    }
});
