/**
 * @param {CryptaSegment} param.interests - список интересов (сегментов с типом interests)
 * @param {Array<SelectedInterest>} param.selected - список интересов, с выбранными сегментами
 */
BEM.DOM.decl('b-crypta-interests-collection', {

    onSetMod: {
        js: function() {
            var items = this.params.items.length ? this.params.items : [{ period: 'all' }];
            this._subMan = BEM.create('i-subscription-manager');
            this._addCollection = this.findBlockInside('add-item', 'button2');
            this._model = BEM.MODEL.create('b-crypta-interests-collection');

            this._initEvents();

            items.forEach(function(item) {
                this._addItem({
                    edit: true,
                    period: item.period,
                    selectedIds: item.ids || []
                });
            }, this);
        }
    },

    /**
     * Подписка на события
     * @private
     */
    _initEvents: function() {
        this._subMan.wrap(this._model)
            .on('interests', 'add', this._onItemAdd, this)
            .on('interests', 'remove', this._onItemRemove, this)
            .on('interests', 'change selected', this._onItemChange, this)
            .on('hideAddButton', 'change', this._onHideAddButtonChange, this);

        this._subMan
            .on(this._addCollection, 'click', function() { this._addItem() }, this);
    },

    /**
     * Обработчик нажатия на кнопку "Добавить еще один набор"
     * @param {Object} [data] - данные набора
     * @param {String} [data.period] - выбранные период сегментов
     * @private
     */
    _addItem: function(data) {
        data || (data = {
            edit: true,
            selectedIds: []
        });

        this._model.addInterests(u._.extend({}, data, {
            items: u._.cloneDeep(this.params.interests)
        }));
    },

    /**
     * Удаляет набор из коллекции
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _deleteItem: function(e, data) {
        this._model.get('interests').getById(data.id).set('destructing', true);
        this._model.get('interests').remove(data.id);
    },

    /**
     * Генерирует имя набора
     * @param {Number} number - номер набора
     * @returns {String}
     * @private
     */
    _getItemName: function(number) {
        return iget2('b-crypta-interests-collection', 'set-name', 'Набор интересов {number}', {
            number: number
        });
    },

    /**
     * Обработчик изменения видимости кнопки добавления нового набора
     * @param {Event} e
     * @param {Object} data
     * @param {Boolean} data.value - значение поля в модели
     * @private
     */
    _onHideAddButtonChange: function(e, data) {
        this.setMod(this.elem('add-item'), 'hidden', data.value ? '' : 'yes');
    },

    /**
     * Обработчик добавления нового набора в модель
     * @param {Event} e
     * @param {Object} data
     * @param {BEM.MODEL} data.model
     * @param {Number} data.model.id - идентификатор модели набора
     * @private
     */
    _onItemAdd: function(e, data) {
        data.model.set('title', this._getItemName(this._model.get('interests').length()));

        BEM.DOM.append(this.elem('collection'), BEMHTML.apply({
            block: 'b-crypta-interests',
            mix: {
                block: 'b-crypta-interests-collection',
                elem: 'item'
            },
            modelId: data.model.id
        }));

        this.triggerChange();
    },

    /**
     * Обработчик удаления набора из модели
     * @param {Event} e
     * @param {Object} data
     * @param {BEM.MODEL} data.model
     * @param {Number} data.model.id - идентификатор модели набора
     * @private
     */
    _onItemRemove: function(e, data) {
        // обновляем заголовки всем блокам, кроме удаляемого
        this._model.get('interests').forEach(function(model, index) {
            model.set('title', this._getItemName(index + 1))
        }, this);
        this.triggerChange();
    },

    /**
     * Обработчик изменения набора из модели
     * @param {Event} e
     * @param {Object} data
     * @param {BEM.MODEL} data.model
     * @param {Number} data.model.id - идентификатор модели набора
     * @private
     */
    _onItemChange: function(e, data) {
        data.field === 'preview' && this.triggerChange();
    },

    triggerChange: function() {
        this.trigger('change', this._model.get('interests').map(function(m) {
            return m.provideData();
        }));
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('delete', 'b-crypta-interests', function(e, data) {
            this._deleteItem(e, data);
        });

        return false;
    }

})
