block('b-crypta-interests').elem('tree')(
    content()(function() {
        var interestGroups = u['b-crypta-interests'].getInterestGroups(),
            selectedIds = this.ctx.selectedIds || [],
            treeBuilder = function(parentId) {
                return interestGroups[parentId] && interestGroups[parentId].map(function(item) {
                    var isChecked = selectedIds.indexOf(item.id) !== -1;

                    return {
                        elem: 'item',
                        content: {
                            block: 'checkbox',
                            js: { live: true },
                            mods: {
                                theme: 'normal',
                                size: 's',
                                checked: isChecked ? 'yes' : '',
                                disabled: (selectedIds.length >= u.consts('cryptaInterestsLimit') && !isChecked) ?
                                    'yes' : '',
                                id: item.id
                            },
                            mix: [{
                                block: 'b-crypta-interests',
                                elem: 'interest-checkbox'
                            }],
                            text: {
                                content: [
                                    { tag: 'span', content: item.name + '&nbsp' },
                                    {
                                        block: 'icon',
                                        mix: {
                                            block: 'b-crypta-interests',
                                            elem: 'info-icon',
                                            js: { message: item.description }
                                        },
                                        mods: { 'size-13': 'info' }
                                    }
                                ]
                            }
                        },
                        children: treeBuilder(item.id)
                    };
                });
            };

        return {
            block: 'b-tree',
            content: treeBuilder(0)
        };
    })
)
