/**
 * @param {String} ctx.name - заголовок набора
 * @param {CryptaSegment} ctx.interests - список интересов (сегментов с типом interests)
 */
block('b-crypta-interests').mod('edit', 'yes')(

    js()(function() {

        return {
            modelId: this.ctx.modelId
        }
    }),

    elem('content').content()(function() {

        return [
            {
                elem: 'header',
                content: [
                    {
                        elem: 'left',
                        content: [
                            {
                                elem: 'name',
                                content: this.ctx.data.title
                            },
                            {
                                block: 'button2',
                                mix: {
                                    block: this.block,
                                    elem: 'delete'
                                },
                                mods: {
                                    theme: 'clear'
                                },
                                content: {
                                    block: 'icon',
                                    mods: {
                                        'size-16': ['trash']
                                    }
                                }
                            }
                        ]
                    },
                    {
                        elem: 'period',
                        content: [
                            {
                                block: 'select2',
                                mods: {
                                    type: 'radio',
                                    size: 's',
                                    text: 'vary',
                                    theme: 'normal'
                                },
                                mix: {
                                    block: this.block,
                                    elem: 'period-select'
                                },
                                val: this.ctx.data.period,
                                items: Object.keys(u['crypta'].periodMapping).map(function(key) {
                                    return {
                                        val: key,
                                        text: u['crypta'].periodMapping[key]
                                    }
                                })
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'body',
                content: [
                    {
                        elem: 'form',
                        selectedIds: this.ctx.data.selectedIds || []
                    }
                ]
            }
        ]
    })

)
