BEM.DOM.decl({ block: 'b-crypta-interests', modName: 'edit', modVal: 'yes' }, {

    /**
     * Подписка на события
     * @private
     */
    _initEvents: function() {

        this.__base.apply(this, arguments);

        this._initEditModEvents();
    },

    /**
     * Подписка на события при редактировании
     * @private
     */
    _initEditModEvents: function() {
        this._subManEdit = this._subManEdit || BEM.create('i-subscription-manager');

        this._periodCtrl = this.findBlockOn('period-select', 'select2');
        this._periodCtrl.setVal(this._model.get('period'));

        this._subManEdit.wrap(this._model)
            .on('selected', 'change', this._onSelectedChange, this)
            .on('canSelectMore', 'change', this._onCanSelectMoreChange, this)
            .on('selectedIds', 'change', this._onSelectedIdsChange, this);

        this._subManEdit
            .on(this._periodCtrl, 'change', this._onPeriodControlChange, this);

        this._updateSelected();
    },

    /**
     * Отрисовка контента блока
     * @private
     */
    _renderContent: function() {

        BEM.DOM.update(this.domElem, BEMHTML.apply({
            block: 'b-crypta-interests',
            mods: {
                edit: 'yes'
            },
            elem: 'content',
            data: this._model.toJSON()
        }));

        this._initEditModEvents();
    },

    /**
     * Отрисовывает форму выбора интересов
     * @private
     */
    _renderTree: function() {
        BEM.DOM.replace(this.findElem('tree'), BEMHTML.apply({
            block: 'b-crypta-interests',
            elem: 'tree',
            selectedIds: this._model.get('selectedIds')
        }));
    },

    /**
     * Обновляет список выбранных интересов
     * @private
     */
    _updateSelected: function() {
        BEM.DOM.replace(this.findElem('summary'), BEMHTML.apply({
            block: 'b-crypta-interests',
            elem: 'summary',
            limit: u.consts('cryptaInterestsLimit'),
            items: this._model.get('selected').slice(0)
        }));
    },

    /**
     * Обработчик изменения периода
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onPeriodControlChange: function(e, data) {
        this._model.set('period', data.currVal);
    },

    /**
     * Обработчик изменения списка выбранных интересов
     * @private
     */
    _onSelectedChange: function() {
        this._updateSelected();
    },

    /**
     * Обработчик изменения возможности выбора сегментов
     * @param {Event} e
     * @param {Object} data
     * @param {Boolean} data.value - значение поля в модели
     * @private
     */
    _onCanSelectMoreChange: function(e, data) {
        var selectedIds = this._model.get('selectedIds');

        this.findBlocksOn('interest-checkbox', 'checkbox').forEach(function(checkbox) {
            var isCheckedInModel = selectedIds.indexOf(Number(checkbox.getMod('id'))) !== -1;

            checkbox.toggleMod('disabled', 'yes', !isCheckedInModel && !data.value);
        })
    },

    /**
     * Обработчик изменения чекбокса
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onChecked: function(e, data) {
        var selectedIds = this._model.get('selectedIds').slice(0),
            id = Number(e.block.getMod('id'));

        if (data.checked) {
            selectedIds.push(id)
        } else {
            u._.remove(selectedIds, function(el) {
                return el === id;
            });
        }

        this._model.set('selectedIds', selectedIds)
    },

    _checkboxes: null,

    /**
     * Возвращает все чекбоксы в дереве
     * @returns {BEM.DOM}
     * @private
     */
    _getCheckboxes: function() {
        return this._checkboxes || (this._checkboxes = this.findBlocksOn('interest-checkbox', 'checkbox'));
    },

    /**
     * Обработчик изменения поля модели
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onSelectedIdsChange: function(e, data) {
        var selectedIds = data.value;

        this._getCheckboxes().forEach(function(checkbox) {
            var isCheckedInModel = selectedIds.indexOf(Number(checkbox.getMod('id'))) !== -1;

            checkbox.toggleMod('checked', 'yes', isCheckedInModel);
        });
    }

});
