/**
 * @param {String} ctx.name - заголовок набора
 * @param {CryptaSegment} ctx.interests - список интересов (сегментов с типом interests)
 */
block('b-crypta-interests')(

    js()(function() {

        return {
            modelId: this.ctx.modelId
        }
    }),

    elem('content').content()(function() {

        return [
            {
                elem: 'header',
                content: [
                    {
                        elem: 'left',
                        content: [
                            {
                                elem: 'name',
                                content: this.ctx.data.title
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'body',
                content: [
                    {
                        elem: 'preview',
                        content: [
                            {
                                elem: 'preview-text',
                                content: this.ctx.data.preview
                            },
                            {
                                elem: 'preview-buttons',
                                content: [
                                    {
                                        block: 'button2',
                                        mix: {
                                            block: this.block,
                                            elem: 'edit'
                                        },
                                        mods: {
                                            theme: 'clear'
                                        },
                                        content: {
                                            block: 'icon',
                                            mods: {
                                                'size-16': ['edit']
                                            }
                                        }
                                    },
                                    {
                                        block: 'button2',
                                        mix: {
                                            block: this.block,
                                            elem: 'delete'
                                        },
                                        mods: {
                                            theme: 'clear'
                                        },
                                        content: {
                                            block: 'icon',
                                            mods: {
                                                'size-16': ['trash']
                                            }
                                        }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ]
    })

)
