BEM.DOM.decl({ block: 'b-crypta-interests' }, {

    onSetMod: {
        js: function() {

            this.on('_edit_*', function() {
                this._renderContent();
            }, this);

            this._initBlock();
            this._initEvents();

            if (this._model.get('edit')) {
                this._onEdit();
            }

            this._renderContent();
        }
    },

    _initBlock: function() {
        this._subMan = BEM.create('i-subscription-manager');

        this._model = BEM.MODEL.getOne({
            name: 'b-crypta-interests',
            id: this.params.modelId
        });
    },

    /**
     * Подписка на события
     * @private
     */
    _initEvents: function() {
        this._subMan.on(this._model, 'destruct', this._onModelDestruct, this);
        this._subMan.on(this._model, 'title', 'change', this._onTitleChange, this);
        this._subMan.on(this._model, 'edit', 'change', function(e, data) {
            this.setMod('edit', data.value ? 'yes' : '');
        }, this);
    },

    /**
     * Отрисовка контента блока
     * @private
     */
    _renderContent: function() {
        this._subManEdit && this._subManEdit.dispose();

        BEM.DOM.update(this.domElem, BEMHTML.apply({
            block: 'b-crypta-interests',
            elem: 'content',
            data: this._model.toJSON()
        }));
    },

    /**
     * Обновляет содержимое заголовка
     * @param {Event} e
     * @param {Object} data
     */
    _onTitleChange: function(e, data) {
        BEM.DOM.replace(this.findElem('name'), BEMHTML.apply({
            block: 'b-crypta-interests',
            elem: 'name',
            content: data.value
        }));
    },

    /**
     * Обработчик нажатия на кнопку удаления набора
     * @private
     */
    _onDeleteClick: function() {
        this.trigger('delete', { id: this._model.id });
    },

    /**
     * Обработчик нажатия на кнопку редактирования набора
     * @private
     */
    _onEdit: function() {
        this.setMod('edit', 'yes');
        this.trigger('edit', { id: this._model.id });
    },

    /**
     * Обработчик удаления интереса из списка выбранных
     * @param {Event} e
     * @param {Object} data - данные события
     * @param {Number} data.id - идентификатор интереса
     * @private
     */
    _onUnselectItem: function(e, data) {
        var selectedIds = this._model.get('selectedIds').slice(0);

        u._.remove(selectedIds, function(el) {
            return el === data.id;
        });

        this._model.set('selectedIds', selectedIds);
    },

    /**
     * Обработки удаления модели
     * @private
     */
    _onModelDestruct: function() {
        this.destruct();
    },

    /**
     * Возвращает текст, который показывается на выключенном интересе при наведении
     * @returns {String}
     * @private
     */
    _getDisabledText: function() {
        return iget2('b-crypta-interests', 'no-more-10', 'Нельзя выбрать больше 10 интересов')
    }

}, {

    /**
     * Показывает подсказку
     * @param {jQuery} domElem
     * @private
     */
    _showTooltip: function(domElem, text) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'normal' },
            tipMix: { block: 'b-crypta-interests', elem: 'tooltip' },
            popupDirections: ['right', 'bottom'],
            delay: 50
        }));

        text.length > 0 && this._tipman.show({
            owner: domElem,
            content: text
        });
    },

    /**
     * Прячет подсказку
     * @private
     */
    _hideTooltip: function() {
        this._tipman && this._tipman.hide();
    },

    live: function() {

        this.liveInitOnBlockInsideEvent('unselect', 'b-crypta-interests__selected-item', function(e, data) {
            this._onUnselectItem(e,data);
        });

        this.liveBindTo('delete', 'click', function() {
            this._onDeleteClick();
        });

        this.liveBindTo('edit', 'click', function() {
            this._onEdit();
        });

        this.liveInitOnBlockInsideEvent('change', 'checkbox', function(e, data) {
            this._onChecked(e, data)
        });

        this.liveBindTo('interest-checkbox', 'pointerover pointerout', function(e, data) {
            var checkbox = this.findBlockOn(e.data.domElem, 'checkbox');
            if (checkbox.hasMod('disabled')) {

                e.type === 'pointerover' ?
                    this.__self._showTooltip(checkbox.domElem, this._getDisabledText()) :
                    this.__self._hideTooltip();
            }

        });

        this.liveBindTo('info-icon', 'pointerover pointerout', function(e, data) {
            var params = this.elemParams(e.data.domElem),
                message = params && params.message;

            if (!message) {
                return;
            }

            if (e.type === 'pointerover') {
                this.__self._showTooltip(e.data.domElem, message);
            } else {
                this.__self._hideTooltip();
            }
        });

        return false;
    }

});
