u.register({
    'b-crypta-interests': {

        /**
         * Отсортированный список Интересов
         */
        _sortedList: null,

        /**
         * Интересы по группам
         */
        _interestGroups: {},

        /**
         * Возвращает отсортированный список Интересов
         * @param {Array} interests
         * @returns {Object}
         */
        getSortedList: function(interests) {
            return this._sortedList || (this._sortedList = this._transformData(interests));
        },

        /**
         * Возвращает Интересы по группам
         * @returns {Object}
         */
        getInterestGroups: function() {
            return this._interestGroups;
        },

        /**
         * Преобразует данные
         * @param {Array} interests
         * @private
         */
        _transformData: function(interests) {
            var groups = this._interestGroups,
                itemsGroup = function(parentId) {
                    return groups[parentId] && groups[parentId].reduce(function(res, item) {
                        res.push(item);
                        res = res.concat(itemsGroup(item.id) || []);

                        return res;
                    }, []);
                };

            interests.forEach(function(interest) {
                groups[interest.parent_id] || (groups[interest.parent_id] = []);
                groups[interest.parent_id].push(interest);
            });

            // Сортируем по алфавиту
            Object.keys(groups).forEach(function(key) {
                groups[key].sort(function(a, b) {
                    return a.name.localeCompare(b.name)
                });
            });

            return itemsGroup(0);
        },

        /**
         * @typedef {Object} InterestsSet
         *
         * @property {'all'|'short_term'|'long_term'} period
         * @property {Array<CryptaSegment>} selected
         */

        calculatePreview: function(period, selected) {
            var names = (selected || [])
                .map(function(m) { return m.name; })
                .join(', ');

            return period === 'all' ?
                names :
                u['crypta'].periodMapping[period] + ': ' + names;
        }

    }
});
