BEM.MODEL.decl('b-crypta-interests', {

    edit: {
        type: 'boolean',
        default: false
    },

    destructing: {
        type: 'boolean',
        default: false
    },

    title: {
        type: 'string'
    },

    period: {
        type: 'enum',
        enum: ['all', 'short_term', 'long_term'],
        default: 'all'
    },

    selectedIds: {
        type: 'array',
        default: []
    },

    selected: {
        type: 'array',
        dependsFrom: ['selectedIds', 'items'],
        default: [],
        calculate: function() {
            var items = this.get('items') || [];

            return items.filter(function(item) {
                return this.get('selectedIds').indexOf(item.id) !== -1;
            }, this);
        }
    },

    items: {
        type: 'array',
        default: [],
        preprocess: function(items) {
            return u['b-crypta-interests'].getSortedList(items);
        }
    },

    canSelectMore: {
        type: 'boolean',
        dependsFrom: ['selected'],
        default: true,
        calculate: function() {
            if (this.get('destructing')) { return true; }

            return this.get('selected').length < u.consts('cryptaInterestsLimit');
        }
    },

    preview: {
        type: 'string',
        dependsFrom: ['period', 'selected'],
        calculate: function() {
            if (this.get('destructing')) { return ''; }

            return u['b-crypta-interests'].calculatePreview(this.get('period'), this.get('selected'));
        }
    }

}, {

    /**
     * Отжимает все
     */
    uncheckAll: function() {
        this.get('items').where({ checked: true }).forEach(function(itemModel) {
            itemModel.set('checked', false);
        })
    },

    /**
     * Возвращает данные
     * @returns {InterestsSet}
     */
    provideData: function() {
        return u._.pick(this.toJSON(), ['period', 'selected', 'preview'])
    }

});
