block('b-crypta-inventory')(

    js()(function() {
        return {
            data: this.ctx.data,
        };
    }),

    content()(function() {
        var profilesDisabled = !!this.ctx.profilesDisabled;

        return [
            {
                elem: 'predictor',
                content: [
                    {
                        block: 'b-crypta-predictor',
                        profilesDisabled: profilesDisabled
                    }
                ]
            },
            {
                elem: 'advisor',
                content: {
                    block: 'crypta-advisor',
                    profilesDisabled: profilesDisabled
                }
            },
            {
                elem: 'summary-wrap',
                content: {
                    elem: 'summary',
                    profilesDisabled: profilesDisabled
                }
            },
            {
                elem: 'copy'
            },
            {
                elem: 'loading',
                content: [
                    {
                        block: 'spin2',
                        mix: {
                            block: this.block,
                            elem: 'spin'
                        },
                        mods: { size: 'm', progress: 'yes' }
                    }
                ]
            }
        ]
    }),

    elem('summary')(

        content()(function() {
            var profilesDisabled = this.ctx.profilesDisabled;

            return [
                {
                    elem: 'summary-title',
                    profilesDisabled: profilesDisabled
                },
                {
                    block: 'crypta-summary-provider',
                    mods: {
                        loading: 'yes'
                    }
                }
            ]
        })
    ),

    elem('summary-title')(

        content()(function() {
            var profilesDisabled = this.ctx.profilesDisabled;

            return [
                iget2('b-crypta-inventory', 'group-settings-text', ' Настройки на группу объявлений'),
                {
                    block: 'icon',
                    mods: {
                        'size-13': 'question',
                        theme: 'light'
                    },
                    mix: [
                        {
                            block: 'b-hintable-popup',
                            js: {
                                hint: applyCtx({
                                    block: this.block,
                                    elem: 'help-content',
                                    content: [
                                        profilesDisabled ?
                                            iget2(
                                                'b-crypta-inventory',
                                                'help-text-no-profiles',
                                                'В списке перечислены настройки группы объявлений, которые учитываются при расчете прогноза: размеры загруженных баннеров и регионы показа.') :
                                            iget2(
                                                'b-crypta-inventory',
                                                'help-text',
                                                'В сводке показаны установленные настройки на группу объявлений, которые влияют на количество доступных для таргетинга пользователей: размеры баннеров, регионы, а также фильтры условия показа. В условии может быть задано несколько фильтров, объединенных оператором "И".'),
                                        !profilesDisabled && {
                                            block: 'b-help-link',
                                            mods: {
                                                type: 'modal'
                                            },
                                            stretched: true,
                                            url: u.getHelpUrl('cpm-campaign-impression-criteria'),
                                            text: iget2('b-crypta-inventory', 'help-text-link', 'Подробнее об условии показа')
                                        }
                                    ]
                                }),
                                directions: ['bottom']
                            }
                        },
                        {
                            block: 'b-crypta-inventory',
                            elem: 'summary-help'
                        }
                    ]
                }
            ]
        })
    ),

    elem('copy').content()(function() {

        return {
            block: 'button2',
            mix: {
                block: this.block,
                elem: 'copy-button'
            },
            mods: {
                theme: 'clear',
                size: 'xs'
            },
            iconLeft: { mods: { 'size-16': 'copy' } },
            text: iget2('b-crypta-inventory', 'copy-button-text', 'Скопировать в буфер обмена')
        }
    })
);
