block('b-crypta-predictor').mod('view', 'advanced')(

    js()(true),

    content()(function() {

        return [
            {
                elem: 'header',
                content: {
                    elem: 'info'
                }
            },
            {
                elem: 'predict',
                elemMods: { indoor: this.ctx.indoor }, // TODO @ruzhansky - DIRECT-97903
                content: [
                    {
                        elem: 'predict-title',
                        elemMods: { reach: true },
                        content: iget2('b-crypta-predictor', 'audience-reach', 'Охват аудитории')
                    },
                    {
                        elem: 'numbers',
                        content: [
                            {
                                elem: 'detailed',
                                content: {
                                    elem: 'predict-value',
                                    elemMods: {
                                        status: 'empty'
                                    }
                                }
                            },
                            {
                                elem: 'basic',
                                content: {
                                    elem: 'predict-value',
                                    elemMods: {
                                        status: 'error'
                                    }
                                }
                            }
                        ]
                    },
                    {
                        block: 'b-progress',
                        mods: {
                            timing: 'linear',
                            size: 'medium',
                            theme: 'deep-blue'
                        },
                        mix: { block: this.block, elem: 'progress-reach' },
                        value: 0
                    }
                ]
            },
            {
                elem: 'predict',
                content: [
                    {
                        elem: 'predict-title',
                        content: 'OTS'
                    },
                    {
                        elem: 'numbers',
                        content: [
                            {
                                elem: 'detailed',
                                elemMods: { ots: true },
                                content: {
                                    elem: 'predict-value',
                                    elemMods: {
                                        status: 'empty'
                                    }
                                }
                            },
                            {
                                elem: 'basic',
                                elemMods: { ots: true },
                                content: {
                                    elem: 'predict-value',
                                    elemMods: {
                                        status: 'error'
                                    }
                                }
                            }
                        ]
                    },
                    {
                        block: 'b-progress',
                        mods: {
                            timing: 'linear',
                            size: 'medium',
                            theme: 'deep-blue'
                        },
                        mix: { block: this.block, elem: 'progress-ots' },
                        value: 0
                    }
                ]
            }
        ]
    }),
    elem('info').content()(function() {

        return [
            {
                elem: 'title',
                content: {
                    elem: 'title-content'
                }
            },
            {
                elem: 'help'
            }
        ]
    }),

    elem('help').content()(function() {

        return {
            block: 'icon',
            mods: {
                'size-13': 'question',
                theme: 'light'
            },
            mix: {
                block: 'b-hintable-popup',
                js: {
                    hint: {
                        block: 'b-crypta-predictor',
                        mods: { view: 'advanced' },
                        elem: 'help-predictor-content'
                    },
                    directions: ['bottom']
                }
            }
        }
    }),

    elem('help-predictor-content').content()(function() {
        return [
            {
                tag: 'ul',
                content: [
                    iget2('b-crypta-predictor', 'predict-help-outdoor-text', 'Прогноз охвата за неделю:'),
                    {
                        tag: 'li',
                        content: iget2('b-crypta-predictor', 'predict-help-list-val-0', 'Справа — общее количество пользователей.'),
                    },
                    {
                        tag: 'li',
                        content: iget2('b-crypta-predictor', 'predict-help-list-val-1', 'Слева — число пользователей, которые потенциально могут увидеть рекламу на выбранных щитах.')
                    }
                ]
            },
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                stretched: true,
                url: u.getHelpUrl('estimate-reach'),
                text: iget2('b-crypta-predictor', 'predict-help-link', 'Подробнее о прогнозе')
            }
        ]
    }),

    elem('title-content').replace()(function() {
        return iget2('b-crypta-predictor', 'title', 'Прогноз аудитории за 7 дней');
    })
);
