BEM.DOM.decl({ name: 'b-crypta-predictor', modName: 'view', modVal: 'advanced' }, {
    onSetMod: {
        js: function() {
            this._progressReach = this.findBlockInside('progress-reach', 'b-progress');
            this._progressOts = this.findBlockInside('progress-ots', 'b-progress');
        },

        loading: {

            yes: function() {
                this._progressReach.setMod('loading', 'yes');
                this._progressOts.setMod('loading', 'yes');
            },

            '': function() {
                this._progressReach.delMod('loading');
                this._progressOts.delMod('loading');
            }

        }
    },

    /**
     * Показать ошибку поверх содержимого блока
     * @param {*} content
     */
    showError: function(content) {
        this._progressReach.update(0);
        this._progressOts.update(0);

        this._renderPredictorValues({ status: 'empty' }, { status: 'error' }, 'detailed');
        this._renderPredictorValues({ status: 'empty' }, { status: 'error' }, 'basic');

        BEM.DOM.update(this.elem('info'), BEMHTML.apply({
            block: 'b-crypta-predictor',
            mods: { view: 'advanced' },
            elem: 'title',
            content: {
                block: 'b-crypta-predictor',
                mods: { view: 'advanced' },
                elem: 'error',
                text: content
            }
        }));

        this.setMod('error', 'yes');
    },

    /**
     * Обновляет прогноз
     * @param {ReachParams} data - параметры запроса
     */
    update: function(data) {
        this.setMod('loading', 'yes');

        if (data) {
            if (data.out.reach_less_than) {
                this.showError(iget2('b-crypta-predictor', 'prediction-is-currently-unavailable', 'Прогноз временно недоступен'));
                this.delMod('loading');

                return;
            }

            var reachOf = this._getInfoFromResult(data.of, 'reach'),
                otsOf = this._getInfoFromResult(data.of, 'ots_capacity'),
                reachOut = this._getInfoFromResult(data.out, 'reach'),
                otsOut = this._getInfoFromResult(data.out, 'ots_capacity');

            this.hideError();

            this._renderPredictorValues(reachOf, otsOf, 'detailed');
            this._renderPredictorValues(reachOut, otsOut, 'basic');
            this._updateProgressBar(reachOf, reachOut, otsOf, otsOut);
        }

        this.delMod('loading');
    },

    /**
     * Спрятать ошибку
     */
    hideError: function() {
        BEM.DOM.update(this.elem('info'), BEMHTML.apply([
            {
                block: 'b-crypta-predictor',
                mods: { view: 'advanced' },
                elem: 'title',
                content: {
                    block: 'b-crypta-predictor',
                    mods: { view: 'advanced' },
                    elem: 'title-content'
                }
            },
            {
                block: 'b-crypta-predictor',
                mods: { view: 'advanced' },
                elem: 'help'
            }
        ]));

        this.delMod('error');
    },

    /**
     * Отображение значений прогноза
     * @param {{value: (*|null|number), errors: (*|any[]), status: string}} reach - Охват
     * @param {{value: (*|null|number), errors: (*|any[]), status: string}} ots - Просмотры
     * @param {'detailed' | 'basic'} type - тип значений
     * @private
     */
    _renderPredictorValues: function(reach, ots, type) {
        if (u._.contains(['empty', 'error'], reach.status) && ots.status !== 'error') {
            this._progressReach.update(1);
            this._progressOts.update(1);

            this._renderNumber('detailed', 'of', reach);
            this._renderNumber('basic', 'of', ots);
        } else if (reach.status === 'error' && ots.status === 'error') {
            this._progressReach.update(0);
            this._progressOts.update(0);

            reach.status = 'empty';

            this._renderNumber('detailed', 'of', reach);
            this._renderNumber('basic', 'out-of', ots);
        } else if (u._.contains(['less', 'error'], reach.status) || ots.status === 'error') {
            this._progressReach.update(0);
            this._progressOts.update(0);

            this._renderNumber('detailed', 'of', reach);
            this._renderNumber('basic', 'out-of', ots);
        } else {
            this._renderNumber(type, type === 'detailed' ? 'of' : 'out-of', reach);
            this._renderNumber(type, type === 'detailed' ? 'of' : 'out-of', ots, 'ots');
        }
    },

    /**
     * Обновление значений progress bar-ов
     * @param {{value: (*|null|number)}} reachOf - Текущее значение охвата
     * @param {{value: (*|null|number)}} reachOut - Максимальное значение охвата
     * @param {{value: (*|null|number)}} otsOf - Текущее значение показов
     * @param {{value: (*|null|number)}} otsOut - Максимальное значеие показов
     * @private
     */
    _updateProgressBar: function(reachOf, reachOut, otsOf, otsOut) {
        this._progressReach.update(u.numberFormatter.round(reachOf.value / reachOut.value,
            { precision: 2, roundType: 'ceil' }));
        this._progressOts.update(u.numberFormatter.round(otsOf.value / otsOut.value,
            { precision: 2, roundType: 'ceil' }));
    },

    /**
     * Обновляет отображение выбранного региона
     * @param {String} selectedRegion - название региона
     */
    updateSelectedRegion: function(selectedRegion) {
        BEM.DOM.update(this.findElem('predict-title', 'reach', true), BEMHTML.apply(
            iget2('b-crypta-predictor', 'audience-reach-on', 'Охват аудитории: {selectedRegion}', { selectedRegion: selectedRegion })
        ));
    },

    /**
     * Парсит ответ запроса ручки getReachOutdoor
     * @param {*} result
     * @param {'reach' | 'ots_capacity'} type: (reach - Охват | ots_capacity - Показы)
     * @returns {{value: (*|null|number), errors: (*|any[]), status: string}}
     * @private
     */
    _getInfoFromResult: function(result, type) {
        var status;

        result || (result = {});

        if (result.errors) {
            status = 'error';
        } else if ((result.reach || result.reach === 0) || result.ots_capacity) {
            status = 'normal';
        } else if (result.reach_less_than) {
            status = 'less';
        } else {
            status = 'empty';
        }

        return {
            status: status,
            value: result && (result[type] || result.reach_less_than),
            errors: result && (result.errors || []).map(this._getGoalInfo.bind(this))
        }
    },

    onReachError: function(response) {
        this.delMod('loading');
        this.showError(u._.get(response, 'obj.text'));
    },

    /**
     * Отрисовывает правую цифру
     * @param {String} name - название элемента
     * @param {'of'|'out-of'} type - тип цифры
     * @param {ReachNumberClient} data
     * @param {String} modName - имя модификатра
     * @private
     */
    _renderNumber: function(name, type, data, modName) {
        BEM.DOM.update(modName ? this.elem(name, modName) : this.elem(name), BEMHTML.apply({
            block: 'b-crypta-predictor',
            elem: 'predict-value',
            elemMods: {
                status: data.status
            },
            type: type,
            data: data
        }));
    }
});
