BEM.DOM.decl({ name: 'b-crypta-predictor', modName: 'view', modVal: 'simple' }, {
    onSetMod: {
        js: function() {
            this._getProgress();
        },

        loading: {

            yes: function() {
                this._getProgress() && this._getProgress().setMod('loading', 'yes');
            },

            '': function() {
                this._getProgress() && this._getProgress().delMod('loading');
            }

        }
    },

    /**
     * Обновляет прогноз
     * @param {ReachParams} data - параметры запроса
     */
    update: function(data) {
        this.setMod('loading', 'yes');

        if (data) {
            if (data.out.reach_less_than) {
                this._progress = null;
                this.showError(iget2('b-crypta-predictor', 'prediction-is-currently-unavailable', 'Прогноз временно недоступен'));
                this.delMod('loading');

                return;
            }

            var isIndoor = this.params.indoor,
                reachOf = this._getInfoFromResult(data.of, isIndoor ? 'ots_capacity' : 'reach'), // TODO @ruzhansky - DIRECT-97903
                reachOut = this._getInfoFromResult(data.out, isIndoor ? 'ots_capacity' : 'reach'); // reach

            this.hideError();

            if (u._.contains(['empty', 'error'], reachOf.status) && reachOut.status !== 'error') {
                this._getProgress().update(1);

                this._renderNumber('detailed', 'of', reachOf);
                this._renderNumber('basic', 'of', reachOut);
            } else if (reachOf.status === 'error' && reachOut.status === 'error') {
                this._getProgress().update(0);

                reachOf.status = 'empty';

                this._renderNumber('detailed', 'of', reachOf);
                this._renderNumber('basic', 'out-of', reachOut);
            } else if (u._.contains(['less', 'error'], reachOf.status) || reachOut.status === 'error') {
                this._getProgress().update(0);

                this._renderNumber('detailed', 'of', reachOf);
                this._renderNumber('basic', 'out-of', reachOut);
            } else {
                this._getProgress().update(u.numberFormatter.round(reachOf.value / reachOut.value, { precision: 2, roundType: 'ceil' }));

                this._renderNumber('detailed', 'of', reachOf);
                this._renderNumber('basic', 'out-of', reachOut);
            }
        }

        this.delMod('loading');
    },

    /**
     * Возвращает инстанс progress
     * @returns {*|BEM}
     * @private
     */
    _getProgress: function() {
        return (this._progress || (this._progress = this.findBlockInside('b-progress')));
    },

    /**
     * Показать ошибку поверх содержимого блока
     * @param {*} content
     */
    showError: function(content) {
        this._renderNumber('detailed', 'of', { status: 'empty' });
        this._renderNumber('basic', 'out-of', { status: 'error' });

        BEM.DOM.update(this.elem('content'), BEMHTML.apply({
            block: 'b-crypta-predictor',
            mods: { view: 'simple' },
            elem: 'error',
            text: content
        }));

        this._progress = null;
        this.setMod('error', 'yes');
    },

    /**
     * Отрисовывает правую цифру
     * @param {String} name - название элемента
     * @param {'of'|'out-of'} type - тип цифры
     * @param {ReachNumberClient} data
     * @private
     */
    _renderNumber: function(name, type, data) {
        BEM.DOM.update(this.findElem(name), BEMHTML.apply([
            name === 'detailed' && {
                block: 'b-crypta-predictor',
                elem: 'reach',
                tag: 'span',
                content: this.params.indoor ? 'OTS' : iget2('b-crypta-predictor', 'reach', 'Охват') // TODO @ruzhansky - DIRECT-97903
            },
            {
                block: 'b-crypta-predictor',
                elem: 'predict-value',
                elemMods: {
                    status: data.status
                },
                type: type,
                data: data
            }
        ]));
    },

    /**
     * Обработчик неудачного ответа с сервера
     * @param {Object} response
     * @private
     */
    onReachError: function(response) {
        this.delMod('loading');
        this.showError(u._.get(response, 'obj.text'));
    },

    /**
     * Скрыть ошибку
     */
    hideError: function() {
        BEM.DOM.update(this.elem('content'), BEMHTML.apply([
            {
                block: 'b-crypta-predictor',
                mods: { view: 'simple' },
                elem: 'numbers'
            },
            {
                block: 'b-progress',
                mods: {
                    timing: 'linear',
                    size: 'medium',
                    theme: 'white'
                },
                value: 0
            }
        ]));

        this._progress = null;
        this.delMod('error');
    },

    /**
     * Парсит ответ запроса ручки getReachOutdoor
     * @param {*} result
     * @param {'reach' | 'ots_capacity'} type: (reach - Охват | ots_capacity - Показы)
     * @returns {{value: (*|null|number), errors: (*|any[]), status: string}}
     * @private
     */
    _getInfoFromResult: function(result, type) {
        var status;

        result || (result = {});

        if (result.errors) {
            status = 'error';
        } else if ((result.reach || result.reach === 0) || result.ots_capacity) {
            status = 'normal';
        } else if (result.reach_less_than) {
            status = 'less';
        } else {
            status = 'empty';
        }

        return {
            status: status,
            value: result && (result[type] || result.reach_less_than),
            errors: result && (result.errors || []).map(this._getGoalInfo.bind(this))
        }
    },

});
