block('b-crypta-predictor')(

    def()(function() {
        return applyNext({
            profilesDisabled: !!this.ctx.profilesDisabled
        });
    }),

    js()(function() {
        return {
            profilesDisabled: this.ctx.profilesDisabled
        };
    }),

    content()(function() {
        var profilesDisabled = this.ctx.profilesDisabled;

        return [
            {
                elem: 'header',
                content: {
                    elem: 'info',
                    profilesDisabled: profilesDisabled
                }
            },
            {
                elem: 'predict',
                content: [
                    {
                        elem: 'numbers',
                        content: [
                            {
                                elem: 'detailed',
                                content: {
                                    elem: 'predict-value',
                                    elemMods: {
                                        status: 'empty'
                                    }
                                }
                            },
                            {
                                elem: 'basic',
                                content: {
                                    elem: 'predict-value',
                                    elemMods: {
                                        status: 'error'
                                    }
                                }
                            }
                        ]
                    },
                    {
                        block: 'b-progress',
                        mods: {
                            timing: 'linear',
                            size: 'big',
                            theme: 'blue'
                        },
                        value: 0
                    }
                ]
            }
        ]
    }),

    elem('info').content()(function() {
        var profilesDisabled = this.ctx.profilesDisabled;

        return [
            {
                elem: 'title',
                content: {
                    elem: 'title-content'
                }
            },
            {
                elem: 'help',
                profilesDisabled: profilesDisabled
            }
        ]
    }),

    elem('title-content').replace()(function() {
        return iget2('b-crypta-predictor', 'title', 'Прогноз аудитории за 7 дней');
    }),

    elem('error').content()(function() {
        return {
            block: 'b-warning-message',
            mods: { type: 'preview', theme: 'transparent' },
            icon: {
                block: 'icon',
                mods: { 'size-12': 'alert' }
            },
            content: this.ctx.text || iget2('b-crypta-predictor', 'error-default-text', 'Прогноз временно недоступен')
        }
    }),

    elem('predict-value')(

        content()(function() {
            var data = this.ctx.data,
                type = this.ctx.type;

            return {
                elem: 'number',
                elemMods: {
                    type: type
                },
                status: data.status,
                value: data.value

            }
        }),

        elemMod('status', 'error').content()(function() {
            var errors = u._.get(this.ctx, 'data.errors', []),
                mix = {};

            if (errors.length) {
                mix = {
                    block: 'b-hintable',
                    js: {
                        hint: applyCtx([
                            {
                                block: this.block,
                                elem: 'help-content',
                                elemMods: { 'goals-list': 'yes' },
                                content: [
                                    iget2('b-crypta-predictor', 'predict-number-error-1', 'К сожалению, мы не знаем сколько пользователей доступно для таргетинга. Посчитать прогноз не получилось из-за настроек: {errors}', {
                                        errors: applyCtx([
                                            {
                                                tag: 'ul',
                                                content: errors.map(function(goal) {
                                                    return {
                                                        elem: 'error-goal',
                                                        tag: 'li',
                                                        content: goal.name || { block: 'b-crypta-predictor', elem: 'goal-not-found', content: goal.goal_id }
                                                    }
                                                })
                                            }
                                        ])
                                    }),
                                    {
                                        block: 'b-help-link',
                                        mods: {
                                            type: 'modal'
                                        },
                                        stretched: true,
                                        url: u.getHelpUrl('estimate-reach'),
                                        text: iget2('b-crypta-predictor', 'predict-help-link', 'Подробнее о прогнозе')
                                    }
                                ]
                            }
                        ]),
                        directions: ['bottom']
                    },
                    mods: {
                        hoverable: 'yes'
                    }
                }
            }

            return {
                elem: 'predict-error',
                mix: mix,
                content: '—'
            }
        }),

        elemMod('status', 'empty').content()(function() {
            return '&nbsp;'
        })

    ),

    elem('number')(

        elemMod('type', 'of')(

            content()(function() {
                var status = this.ctx.status,
                    value = this.ctx.value;

                return status === 'less' ?
                    iget2('b-crypta-predictor', 'detailed-less', '&lt;{detailed}', {
                        detailed: u.humanizeNumberValue(value, 2),
                        context: '<100 млн'
                    }) :
                    iget2('b-crypta-predictor', 'detailed', '{detailed}', {
                        detailed: u.humanizeNumberValue(value, 2),
                        context: '100 млн'
                    })
            })
        ),

        elemMod('type', 'out-of')(

            content()(function() {
                var status = this.ctx.status,
                    value = this.ctx.value;

                return status === 'less' ?
                    iget2('b-crypta-predictor', 'basic-less', 'из <{basic}', {
                        basic: u.humanizeNumberValue(value, 2),
                        context: 'из <100 млн'
                    }) :
                    iget2('b-crypta-predictor', 'basic', 'из {basic}', {
                        basic: u.humanizeNumberValue(value, 2),
                        context: 'из 100 млн'
                    })
            })
        )

    ),

    elem('help').content()(function() {
        var profilesDisabled = this.ctx.profilesDisabled,
            requestId = this.ctx.requestId;

        return {
            block: 'icon',
            mods: {
                'size-13': 'question',
                theme: 'light'
            },
            mix: {
                block: 'b-hintable-popup',
                js: {
                    hint: {
                        block: 'b-crypta-predictor',
                        elem: 'help-predictor-content',
                        requestId: requestId,
                        profilesDisabled: profilesDisabled,
                    },
                    directions: ['bottom']
                }
            }
        }
    }),

    elem('help-predictor-content').content()(function() {
        var requestId = this.ctx.requestId,
            profilesDisabled = this.ctx.profilesDisabled;

        return [
            !!requestId && iget2('b-crypta-predictor', 'predict-help-id', 'Уникальный ID прогноза: {requestId}', {
                requestId: requestId
            }),
            {
                tag: 'ul',
                content: [
                    iget2('b-crypta-predictor', 'predict-help-text', 'Прогноз количества доступных для таргетинга пользователей РСЯ за неделю:'),
                    {
                        tag: 'li',
                        content: profilesDisabled ?
                            iget2(
                                'b-crypta-predictor',
                                'predict-help-list-0-no-profiles',
                                'Справа — общее количество пользователей. Это значение зависит от выбранных в заказе регионов показа и версии сайта.'
                            ) :
                            iget2(
                                'b-crypta-predictor',
                                'predict-help-list-0',
                                '(справа) Общее количество пользователей, без учета условия показа. На расчет влияют список запрещенных площадок, размеры баннеров и регионы.'
                            ),
                    },
                    {
                        tag: 'li',
                        content: profilesDisabled ?
                            iget2(
                                'b-crypta-predictor',
                                'predict-help-list-1-no-profiles',
                                'Слева — число пользователей, с учетом размеров загруженных баннеров и уточненных на группе регионов.'
                            ) :
                            iget2(
                                'b-crypta-predictor',
                                'predict-help-list-1',
                                '(слева) Уточненное количество пользователей, с учетом фильтров заданных в условии показа: пол, возраст, доход, наличие детей, интересы и другие.')
                    }
                ]
            },
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                stretched: true,
                url: profilesDisabled ? u.getHelpUrl('estimate-reach-frontpage') : u.getHelpUrl('estimate-reach'),
                text: iget2('b-crypta-predictor', 'predict-help-link', 'Подробнее о прогнозе')
            }
        ]
    })

);
