block('b-crypta-segments').mod('type', 'behaviors')(

    js()(function() {
        return {
            segments: this.ctx.segments
        }
    }),

    content()(function() {

        return {
            elem: 'content',
            content: []
        }
    }),

    elem('category').content()(function() {
        return [
            {
                elem: 'category-title',
                content: this.ctx.title
            },
            {
                elem: 'category-body',
                content: this.ctx.segments.map(function(segment) {
                    return {
                        block: 'b-segment',
                        mix: {
                            block: 'b-crypta-segments',
                            elem: 'segment'
                        },
                        segment: segment
                    }
                })
            }
        ]
    }),

    elem('segments').content()(function() {
        var segments = this.ctx.segments,
            groups = {};

        segments.forEach(function(segment) {
            if (!segment.parent_id) {
                groups[segment.id] || (groups[segment.id] = { children: [] });
                groups[segment.id].parent = segment;
            } else {
                groups[segment.parent_id] || (groups[segment.parent_id] = { children: [] });
                groups[segment.parent_id].children.push(segment);
            }
        });

        return Object.keys(groups).map(function(id) {
            return {
                elem: 'category',
                title: groups[id].parent.name,
                segments: groups[id].children
            }
        });
    })

)
