block('b-crypta-segments').mod('type', 'socdemo')(

    js()(function() {
        return {
            segments: this.ctx.segments
        }
    }),

    elem('category').content()(function() {
        return [
            {
                elem: 'category-title',
                content: this.ctx.title
            },
            {
                elem: 'category-body',
                content: this.ctx.segments.map(function(segment) {
                    return {
                        block: 'b-segment',
                        mix: {
                            block: 'b-crypta-segments',
                            elem: 'segment'
                        },
                        segment: segment
                    }
                })
            }
        ]
    }),

    elem('segments').content()(function() {
        var segments = this.ctx.segments,
            mapping = this.ctx.mapping;

        return [
            {
                elem: 'category',
                title: iget2('b-crypta-segments', 'pol', 'Пол'),
                segments: segments.filter(function(segment) {
                    return mapping['gender'].indexOf(segment.id) !== -1;
                })
            },
            {
                elem: 'category',
                title: iget2('b-crypta-segments', 'vozrast', 'Возраст'),
                segments: segments.filter(function(segment) {
                    return mapping['age'].indexOf(segment.id) !== -1;
                })
            },
            {
                elem: 'category',
                title: iget2('b-crypta-segments', 'dohod', 'Доход'),
                segments: segments.filter(function(segment) {
                    return mapping['finance'].indexOf(segment.id) !== -1;
                })
            }
        ];
    }),

    content()(function() {

        return {
            elem: 'content',
            content: []
        }
    })

)
