BEM.DOM.decl('b-crypta-segments', {

    onSetMod: {

        js: function() {
            this._subMan = BEM.create('i-subscription-manager');
            this._segments = this.params.segments || [];
            this._segmentsModels = [];

            this._createModels();
            this.renderSegments();
        }

    },

    /**
     * Создает модели сегментов
     * @private
     */
    _createModels: function() {
        this._segments.forEach(function(segment) {
            var segmentModel = BEM.MODEL.create('dm-segment', segment);

            this._segmentsModels.push(segmentModel);
            this._subscribeOnChange(segmentModel);
        }, this);
    },

    /**
     * Подписка на изменение модели
     * @param {'BEM.MODEL<dm-segment>'} model
     * @private
     */
    _subscribeOnChange: function(model) {
        this._subMan.on(model, 'change', function(e, data) {
            this.trigger('change', {
                id: e.target.get('id'),
                value: data.value
            });
        }, this);
    },

    /**
     * Отрисовывает форму
     */
    renderSegments: function() {
        //будет переопределен
    },

    /**
     * Возвращает текущее состоянии формы
     * @returns {Array}
     */
    getValue: function() {
        return this._segmentsModels.map(function(model) { return model.toJSON() });
    },

    /**
     * Выключает чекбоксы
     * @param {Array<Number>} ids - массив idшников
     * @param {Boolean} value
     */
    setDisable: function(ids, value) {
        this._segmentsModels.forEach(function(m) {
            ids.indexOf(m.get('id')) !== -1 && m.set('disabled', value);
        });
    }

});
