BEM.DOM.decl({ block: 'b-crypta-settings', modName: 'inventory', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['resize-watcher'].getInstance({
                owner: this.domElem,
                ignoreWidth: true,
                timeout: null
            }).on('change', function(e, data) {
                this.updateInventoryHeight();
            }, this);

            this._updateInventoryHeightBinded = this.updateInventoryHeight.bind(this);

            BEM.DOM.win.bind('resize', this._updateInventoryHeightBinded);

        },

        'predictor-loading': {

            yes: function() {
                this._getInventory().setMod('predictor-loading', 'yes');
            },

            '': function() {
                this._getInventory().delMod('predictor-loading');
            }

        }

    },

    _getInventory: function() {
        return this._inventory || (this._inventory = this.blockInside('b-crypta-inventory'));
    },

    /**
     * Проверяет блок на готовность
     */
    isReady: function() {
        return this.__base.apply(this, arguments) && this._getInventory().isReady();
    },

    /**
     * Обновление стакана
     * @param {PredictParams} data
     */
    updateInventory: function(data) {
        this._getInventory().update(data);
        this.updateInventoryHeight();
    },

    /**
     * Обновляет высоту стакана
     */
    updateInventoryHeight: function() {

        if (!this.domElem.is(':visible')) { return; }

        var domElemHeight = this.domElem.height(),
            windowHeight = window.innerHeight,
            inventoryHeight = 0,
            isIE11 = /Trident.*rv[ :]*11\./.test(navigator.userAgent);

        // мы не можем обернуть содержимое в еще один div, потому-что в IE будет все плохо
        this._getInventory().domElem.find(' > *').each(function(index, el) {
            inventoryHeight += el.offsetHeight;
        });

        inventoryHeight = inventoryHeight -
            this._getInventory().elem('summary-wrap').height() + this._getInventory().elem('summary-wrap')[0].scrollHeight;

        if (domElemHeight > inventoryHeight) {
            if ((windowHeight - 30) > inventoryHeight || isIE11) {
                this.setMod(this.elem('inventory'),'height', 'auto');
            } else {
                this.setMod(this.elem('inventory'),'height', 'window');
            }
        } else {
            this.setMod(this.elem('inventory'),'height', 'full');
        }
    },

    /**
     * Подписка на события
     * @private
     */
    _initEvents: function() {
        this.__base.apply(this, arguments);
        this._subMan.on(this._getInventory(), 'ready', this._onSomeReady, this);
    },

    destruct: function() {
        BEM.DOM.win.unbind('resize', this._updateInventoryHeightBinded);
        this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('conditions:add', 'b-conditions-display', function(e, data) {
            this.trigger('conditions:add', data);
        });

        return this.__base.apply(this, arguments);
    }

});
