BEM.DOM.decl({ block: 'b-crypta-settings' }, {

    onSetMod: {
        js: function() {
            this._initBlocks();
            this._initEvents();
        }
    },

    /**
     * Проверяет блок на готовность
     */
    isReady: function() {
        return this._conditionsDisplay.isReady();
    },

    /**
     * Поиск блоков и их кеширование
     * @private
     */
    _initBlocks: function() {
        this._conditionsDisplay = this.findBlockInside('b-conditions-display');
    },

    /**
     * Подписка на события
     * @private
     */
    _initEvents: function() {
        this._subMan = BEM.create('i-subscription-manager');
        this._subMan.on(this._conditionsDisplay, 'ready', this._onSomeReady, this);
    },

    /**
     * Обработчик события ready на дочерних блоках
     * @private
     */
    _onSomeReady: function() {
        this.isReady() && this.trigger('ready');
    },

    destruct: function() {
        this._subMan.destruct();
        this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('conditions:change', 'b-conditions-display', function() {
            this.trigger('conditions:change');
        });

        return false;
    }

});
