BEM.DOM.decl('b-csv-set-phrases-prices', {
    onSetMod: {
        js: function() {
            this._pricesConstructor = this.findBlockInside('b-prices-constructor');

            this.bindEvents();
        }
    },

    bindEvents: function() {
        this._pricesConstructor
            .highlightErrorInputs()
            .on('validated', function(e, data) {
                this.trigger('validated', data);
            }, this);

        return this;
    },

    /**
     * Возвращает данные из конструктора ставок
     * @returns {Object}
     */
    getData: function() {
        return this._pricesConstructor.getData();
    },

    /**
     *
     * @param {Object} options
     * @param {Boolean} options.isDisabled
     * @returns {BEM}
     */
    setDisabled: function(options) {
        this._pricesConstructor.disablePlace('search', options.isDisabled);

        return this;
    }
}, {

});
