(function() {
/*jshint -W015*/

    var blocks = BEM.blocks,
        bPage = blocks['b-page'].getInstance();

    BEM.DOM.decl('b-data-list', {

        onElemSetMod: {

            desc: {

                hlted: function(elem, modName, modVal) {
                    elem.bem('button').setMod('theme', modVal == 'yes' ? 'orange' : 'normal');
                }

            }

        },

/* Поиск */

    /**
     * @private
     * @type {BEM}
     */
        _iSearchable: null,

    /**
     * @private
     * @type {BEM}
     */
        _bSearchOnList: null,

    /**
     * Инициализация поиска
     * @param {Object} items Данные для поиска
     * @param {String} items.searchIndex
     * @param {String} items.desc
     * @param {Object} items.totals
     * @param {Boolean} items.isFav
     * @param {Boolean} items.isMy
     * @param {jQuery} items.domElem
     * @param {Boolean} [type] Имя модификатора type
     * @returns {BEM}
     */
        initSearch: function(items, type) {

            this._iSearchable = BEM.create(
                {
                    block: 'i-searchable',
                    mods: type ?
                        { type: type } :
                        {}
                },
                { items: items }
            )
            .on('search.found', this._onSearchFound, this)
            .on('search.missed', this._onSearchMissed, this)
            .on('search.start', this._onSearchStart, this)
            .on('search.finish', this._onSearchFinish, this);

            this.findBlockOutside('b-search-on-list').on('change', function(e, data) {
                this.search({ text: $.trim(data) });
            }, this);

            return this;
        },

    /**
     * Метод поиска
     * @param {Object} query Параметры
     *  @param {String} query.text Искомая строка
     */
        search: function(query) {
            this.getSearchable().search(query);
        },

    /**
     * Обработчик события совпадения
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Object} data.item найденный элемент
     *  @param {Object} data.iterator итератор поиска
     */
        _onSearchFound: function(e, data) {
            var iterator = data.iterator,
                domElem = data.item.domElem;

            this.delMod(domElem, 'hidden');

            if (iterator.empty || iterator.visible.length) {
                this.highlight(data);
            } else {
                this.setMod(domElem, 'hidden', 'yes');
            }
        },

    /**
     * Обработчик события не совпадения
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Object} data.item не найденный элемент
     *  @param {Object} data.iterator итератор поиска
     */
        _onSearchMissed: function(e, data) {
            this.setMod(data.item.domElem, 'hidden', 'yes');
        },

    /**
     * Обработчик события начала поиска
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Object} data.iterator итератор поиска
     */
        _onSearchStart: function(e, data) {},

    /**
     * Обработчик события окончания поиска
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Object} data.iterator итератор поиска
     */
        _onSearchFinish: function(e, data) {},

    /**
     * Подсветка совпавшей подстроки
     * @param {Object} data
     *  @param {Object} data.item найденный элемент
     *  @param {Object} data.iterator итератор поиска
     */
        highlight: function(data) {
            var iterator = data.iterator,
                item = data.item,
                index = iterator.iteration,
                domElem = item.domElem,
                originalValues = this.getOriginalValues(domElem, index),
                queryText = iterator.query.text,
                descMatched = queryText.length && ~item.desc.indexOf(queryText);

            this.getHltBlocks(domElem, index).each(function(index, hlt) {
                var html = originalValues[index].replace(iterator.regexp, function(str) {
                    return BEMHTML.apply({
                        block: 'b-search-on-list',
                        elem: 'hlted',
                        content: str
                    });
                });

                hlt.innerHTML != html && (hlt.innerHTML = html);
            });

            this.setMod(this._getDescNode(domElem, iterator.iteration), 'hlted', descMatched ? 'yes' : '');

        },

    /**
     * @private
     * @type {Object}
     */
        _descNodeChache: null,

    /**
     * Возвращает кнопку открывающую попап с примечаниями
     * @param {jQuery} domElem DOM-нода строки
     * @param {Number} index index строки
     * @returns {jQuery}
     */
        _getDescNode: function(domElem, index) {
            !this._descNodeChache && (this._descNodeChache = {});

            return this._descNodeChache[index] || (this._descNodeChache[index] = this.findElem(domElem, 'desc'));
        },

    /**
     * Получаем массив строк среди которых происходит поиск
     * @param {jQuery} domElem
     * @param {Number} index
     * @returns {Array}
     */
        getOriginalValues: function(domElem, index) {
            var hltBlocksText;

            return domElem.data('highlight.original') || domElem.data(
            'highlight.original',
            hltBlocksText = this.getHltBlocks(domElem, index).map(function(i, htl) {
                return htl.innerHTML;
            })
        ) && hltBlocksText;
        },

    /**
     * @private
     * @type {Array}
     */
        _chacheHltBlocks: null,

    /**
     * Получаем искомые элементы в указанной DOM-ноде
     * @param {jQuery} domElem
     * @param {Number} index
     * @returns {jQuery}
     */
        getHltBlocks: function(domElem, index) {
            this._chacheHltBlocks || (this._chacheHltBlocks = []);

            return this._chacheHltBlocks[index] || (this._chacheHltBlocks[index] = this.findElem(domElem, 'hlt'));
        },

    /**
     * Получаем экземпляр блока 'i-searchable'
     * @returns {BEM}
     */
        getSearchable: function() {
            return this._iSearchable;
        },

/* END Поиск */

/* Фиксирование ширины таблицы */

    /**
     * Инициализация пересчёта ширин ячеек и таблицы
     * @returns {BEM}
     */
        initRecountTableWidths: function() {
            this._setTableWidths();

            blocks['i-resize'].getInstance()
                .on('start', this._removeTableWidths, this)
                .on('end', this._setTableWidths, this);

            return this;
        },

    /**
     * @private
     * @type {Array}
     */
        _captionCells: null,

    /**
     * Возвращает массив с наборами ячеек-заголовков
     * @private
     * @returns {jQuery[]}
     */
        _getCaptionCells: function() {
            if (!this._captionCells) {
                this._captionCells = [];

                this.elem('head').each(function(index, head) {
                    this._captionCells.push(this.findElem($(head), 'cell'));
                }.bind(this));
            }

            return this._captionCells;
        },

    /**
     * Устанавливает фиксированные ширины ячейкам и таблице
     * @private
     */
        _setTableWidths: function() {
            var tableWidth = this.elem('table')[0].offsetWidth,
                captionCells = this._getCaptionCells();

        // Высчитываем ширины ячеек в заголовке только у первой группы,
        // а выставляем ячейкам в заголовке у каждой (потому что при фильтрации группа может спрятаться полностью)
            captionCells[0].each(function(index, cell) {
                var cellWidth = cell.offsetWidth / tableWidth * 100 + '%';

                captionCells.forEach(function(cellsFromRow) {
                    cellsFromRow.eq(index).width(cellWidth);
                });
            });

            this.elem('table').width(tableWidth);
        },

    /**
     * Сбрасывает фиксированную ширину таблице
     * @private
     */
        _removeTableWidths: function() {
            this.elem('table').css('width', '100%');
        },

/* END Фиксирование ширины таблицы */

/* Mass actions */

    /**
     * Инициализация массовых действий
     * @returns {BEM}
     */
        initMassActions: function() {
            blocks['b-checkboxes-group'].on(this.domElem, 'change', this._onCheckboxesChange, this);

            this.getSearchable() && this.getSearchable().on('search.finish', this._onSearchFinishForActions, this);

            return this;
        },

    /**
     * Обработчик изменений в группе чекбоксов
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data] Объект с индексами выбранных чекбоксов
     */
        _onCheckboxesChange: function(e, data) {
            var checked = data.indexes.sort(function(a, b) { return a > b });

            this._getMassActions().updateActions(checked);
        },

    /**
     * Обработчик события окончания поиска
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Object} data.iterator итератор поиска
     */
        _onSearchFinishForActions: function(e, data) {
            var ignored = {};

            data.iterator.hidden.forEach(function(indexHidden) {
                ignored[indexHidden] = true;
            });

            this._getCheckboxesGroup().setIgnored(ignored);
        },

    /**
     * @private
     * @type {BEM}
     */
        _checkboxGroup: null,

    /**
     * Возвращает экземпляр блока 'b-checkboxes-group'
     * @private
     * @returns {BEM}
     */
        _getCheckboxesGroup: function() {
            return this._checkboxGroup || (this._checkboxGroup = this.findBlockInside('b-checkboxes-group'));
        },

    /**
     * @private
     * @type {BEM}
     */
        _bMassActions: null,

    /**
     * Возвращает экземпляр блока 'b-mass-actions'
     * @private
     * @returns {BEM}
     */
        _getMassActions: function() {
            return this._bMassActions || (this._bMassActions = this.findBlockInside('b-mass-actions'));
        },

/* END Mass actions */

/* Примечания */

    /**
     * Инициализация примечаний
     * @returns {BEM}
     */
        initDescriptions: function() {
            blocks['b-description-popup']
                .on(this.elem('description-popup'), 'change', this._onDescriptionChange, this);

            return this;
        },

    /**
     * @private
     * @type {BEM}
     */
        _bDescriptionPopup: null,

    /**
     * Возвращает экземпляр блока 'b-description-popup'
     * @private
     * @returns {BEM}
     */
        _getDescriptionPopup: function() {
            return this._bDescriptionPopup || (this._bDescriptionPopup =
            this.findBlockOn('description-popup', 'b-description-popup'));
        },

    /**
     * Обработчик события изменения примечания
     * @private
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     *  @param {Number} data.index индекс изменённого примечания
     *  @param {jQuery} data.domElem DOM-нода кнопки открывшей попап с примечаниями
     *  @param {String} data.text текст нового примечания
     */
        _onDescriptionChange: function(e, data) {
            var desc = data.text;

            this.getSearchable() && this.getSearchable().changeDescription(data.index, desc);
            this.setMod(data.domElem.data('desc', desc), 'empty', desc.length ? '' : 'yes');
        },

    /**
     * Обработчик клика по кнопке открывающей попап с примечаниями
     * @private
     * @param {jQuery.Event} e
     */
        _onDescriptionClick: function(e) {
            var domElem = e.data.domElem,
                descData = this.elemParams(domElem),
                descTextFromDomELem = domElem.data('desc');

            typeof descTextFromDomELem !== 'undefined' && (descData.text = descTextFromDomELem);

            this._getDescriptionPopup().toggle(domElem, descData);
        }

/* Примечания */

    }, {

        live: function() {
            this.liveBindTo('desc', 'click', function(e) {
                this._onDescriptionClick(e);
            });

            return false;
        }

    });

})();
