block('b-data-table').mod('sortable', 'client')(

    js()(function() { return true }),

    def()(function() {
        var ctx = this.ctx,
            columns = ctx.columns,
            sortBy = ctx.sortBy,
            defaultSortFunction = function(a, b) {
                if (a[sortBy] < b[sortBy]) {
                    return -1;
                } else if (a[sortBy] == b[sortBy]) {
                    return 0;
                } else {
                    return 1;
                }
            },
            reverse = ctx.reverse,
            sortFunction = this._.isFunction(ctx.sortFunction) ? ctx.sortFunction : defaultSortFunction,
            sortedRows = ctx.rows;

        sortBy && sortedRows.sort(sortFunction);
        reverse && sortedRows.reverse();

        return applyNext({
            'ctx.columns': columns,
            'ctx.rows': sortedRows,
            sortBy: sortBy,
            reverse: reverse
        });
    }),

    elem('cell')(

        elemMod('type', 'head')(

            def().match(function() { return this.ctx.key })(function() {
                return applyNext({
                    'elemMods.key': this.ctx.key,
                    'elemMods.sort': this.sortBy === this.ctx.key ?
                        (this.reverse ? 'desc' : 'asc') :
                        this.elemMods.sort
                });
            }),

            content()(function() {
                return {
                    block: 'link',
                    mods: { pseudo: 'yes', theme: 'without-border' },
                    mix: [{ block: 'b-data-table', elem: 'sort-link' }],
                    content: [
                        this.ctx.content,
                        {
                            block: 'b-data-table',
                            elem: 'direction',
                            elemMods: { reverse: 'on' },
                            content: '↓'
                        },
                        {
                            block: 'b-data-table',
                            elem: 'direction',
                            elemMods: { reverse: 'off' },
                            content: '↑'
                        }
                    ]
                };
            })
        )

    ),

    elem('direction').tag()('span')
);
