BEM.DOM.decl({ block: 'b-data-table', modName: 'sortable', modVal: 'client' }, {

    onSetMod: {

        js: function() {
            BEM.blocks['b-link'].on(this.elem('sort-link'), 'click', function(e) {
                var ctx = e.block.domElem.closest(this.buildSelector('cell')),
                    direction;

                if (direction = this.getMod(ctx, 'sort')) {
                    this.setMod(ctx, 'sort', direction = direction === 'asc' ? 'desc' : 'asc');
                } else {
                    this
                        .delMod(this.elem('cell'), 'sort')
                        .setMod(ctx, 'sort', direction = 'asc');
                }

                this.sort(this.elem('cell', 'sort', direction).index(), direction);
            }, this);
        }

    },

    /**
     * Сортировка строк таблицы
     * @param {Number} index номер столбца
     * @param {String} direction тип сортировки (asc/desc)
     */
    sort: function(index, direction) {
        var rows = this.elem('row'),
            reverse = direction === 'desc',
            sortedRows;

        rows.detach();

        sortedRows = rows.sort(function(r1, r2) {
            var cell1 = $(r1.children[index]).text(),
                cell2 = $(r2.children[index]).text();

            if (reverse && cell1 > cell2 || !reverse && cell1 < cell2) {
                return -1;
            } else if (cell1 === cell2) {
                return 0;
            } else {
                return 1;
            }
        });

        // восстанавливаем нумерацию отсортированных строк
        if (this.getMod('has-num-column')) {
            sortedRows = sortedRows.each(function(n, row) {
                row.children[0].innerText = n + 1;
            });
        }

        this.domElem.append(sortedRows);

        this.trigger('sorted');
    }

});
