block('b-data-table')(

    tag()('table'),

    def()(function() {
        return applyNext({
            'ctx.rows': this.ctx.rows.map(function(row, n) {
                row || (row = {});
                row._rowIndex = n;

                return row;
            })
        })
    }),

    js()(function() {
        return u._.isFunction(this.ctx.jsParams) ? this.ctx.jsParams(this.ctx.rows) : this.ctx.jsParams;
    }),

    content()(function() {
        var ctx = this.ctx,
            mixes = ctx.mixes,
            columns = ctx.columns,
            rowTransform = ctx.rowTransform,
            rowParams = ctx.rowParams,
            rowMix = mixes && mixes.row,
            groupMixes = mixes && mixes.group,
            rows = [{
                elem: 'head',
                columns: columns,
                sortBy: ctx.sortBy,
                reverse: ctx.reverse,
                cellMixes: mixes && mixes.headerCell,
                headerRowMixes: mixes && mixes.headerRow
            }];

        function rowBuilder(row) {
            return {
                elem: 'row',
                mix: u._.isFunction(rowMix) ? rowMix(row) : rowMix,
                cellMixes: mixes && mixes.cell,
                row: row,
                columns: columns,
                rowParams: rowParams,
                rowTransform: rowTransform
            }
        }

        return {
            elem: 'body',
            content: rows.concat(ctx.rows.map(function(row) {
                if (row.groupData) {
                    var groupContent = [rowBuilder(row)];

                    row.groupData.map(function(row) {
                        groupContent.push(rowBuilder(row));
                    });

                    return {
                        elem: 'group',
                        mix: groupMixes,
                        content: groupContent
                    }
                } else {
                    return rowBuilder(row);
                }

            }))
        };
    }),

    elem('body').tag()('tbody'),

    elem('group').tag()('tbody'),

    elem('head')(

        tag()('tr'),

        mix()(function() { return this.ctx.headerRowMixes }),

        content()(function() {
            return this.ctx.columns.map(function(column) {
                if (!column) return;

                var mods = { type: 'head' },
                    cellMix = this.ctx.cellMixes;

                column.key == this.ctx.sortBy && (mods.reverse = this.ctx.reverse ? 'on' : 'off');

                return {
                    elem: 'cell',
                    elemMods: mods,
                    key: column.key,
                    sortUrl: column.sortUrl,
                    mix: u._.isFunction(cellMix) ? cellMix(column.key) : cellMix,
                    content: column.title
                }
            }, this);
        })

    ),

    elem('row')(

        tag()('tr'),

        js()(function() {
            return this.ctx.rowParams && (typeof this.ctx.rowParams === 'function' ?
                this.ctx.rowParams(this.ctx.row) :
                this.ctx.rowParams);
        }),

        content()(function() {
            var res = [],
                ctx = this.ctx,
                row = ctx.row,
                cellMix = ctx.cellMixes,
                rowTransform = ctx.rowTransform || '';

            ctx.columns.map(function(column) {
                if (!column) return;

                var key = column.key;

                res.push({
                    elem: 'cell',
                    mix: u._.isFunction(cellMix) ? cellMix(key, row) : cellMix,
                    content: u._.isFunction(column.transformData) ? column.transformData(row, row._rowIndex + 1) : row[key]
                });
            });

            if (u._.isFunction(rowTransform)) {
                res = rowTransform(res, row);
            }

            return res;
        })
    ),

    elem('cell').tag()('td'),

    mod('has-num-column', 'yes').def()(function() {
        var columns = this.ctx.columns,
            startIndex = this.ctx.startIndex || 0;

        columns.splice(this.ctx.numColPos || 0, 0, {
            title: this.ctx.numColTitle || '',
            sortDisable: true,
            transformData: function(data) {
                return data._rowIndex + startIndex + 1;
            }
        });

        this.ctx.columns = columns;
        return applyNext();
    }),

    mod('sortable', 'server')(

        def()(function() {
            var ctx = this.ctx,
                anchor = ctx.anchor,
                columns = ctx.columns,
                url = u.getCurrentUrl(),
                sortParam = url && url.match(/sort=(\S+?)(?:&|$)/),
                sortBy = ctx.sortBy || sortParam && sortParam[1],
                defaultSortFunction = function(a, b) {
                    if (a[sortBy] < b[sortBy]) {
                        return -1;
                    } else if (a[sortBy] == b[sortBy]) {
                        return 0;
                    } else {
                        return 1;
                    }
                },
                reverseParam = url && url.match(/reverse=(0|1)(?:&|$)/),
                disabledSort = ctx.disabledSort, // решение временное
                disabledReverse = ctx.disabledReverse, // решение временное
                reverse = ctx.reverse || reverseParam && reverseParam[1] == 1,
                sortFunction = u._.isFunction(ctx.sortFunction) ? ctx.sortFunction : defaultSortFunction,
                sortedRows = ctx.rows;

            columns.forEach(function(column) {
                if (column && column.key && !column.sortDisable) {

                    !sortBy && (sortBy = column.key);

                    var urlReverse = sortBy != column.key ? (column.reverse || '0') : (reverse ? '0' : '1');

                    column.sortUrl = sortParam ?
                         url.replace(sortParam[0], sortParam[0].replace(sortParam[1], column.key)) :
                         url + '&sort=' + column.key;

                    column.sortUrl = reverseParam ?
                        column.sortUrl.replace(reverseParam[0], reverseParam[0].replace(reverseParam[1], urlReverse)) :
                        (column.sortUrl + '&reverse=' + urlReverse);

                    if (anchor) column.sortUrl += '#' + anchor;
                }
            });

            !disabledSort && sortBy && sortedRows.sort(sortFunction);

            !disabledReverse && reverse && sortedRows.reverse();

            return applyNext({
                'ctx.columns': columns,
                'ctx.sortBy': sortBy,
                'ctx.reverse': reverse,
                'ctx.sortedRows': sortedRows
            });
        }),

        elem('cell')(

            elemMod('type', 'head').match(function() { return this.ctx.sortUrl }).content()(function() {
                return { block: 'link',
                    mix: [{ elem: 'sort-link', block: 'b-data-table' }],
                    url: this.ctx.sortUrl,
                    content: this.ctx.content
                };
            }),

            elemMod('reverse', 'on').content()(function() {
                return [
                    applyNext(),
                    {
                        elem: 'reverse',
                        content: '↓'
                    }
                ];
            }),

            elemMod('reverse', 'off').content()(function() {
                return [
                    applyNext(),
                    {
                        elem: 'reverse',
                        content: '↑'
                    }
                ];
            })
        )

    ),

    elem('reverse').tag()('span')
);
