block('b-date-range-picker').mod('type', 'super')(

    js()(function() {
        return {
            id: this.ctx.id,
            start: this.ctx.start,
            finish: this.ctx.finish,
            center: this.ctx.center,
            minDate: this.ctx.minDate,
            maxDate: this.ctx.maxDate,
            dateFormat: this.ctx.dateFormat || 'YYYY-MM-DD',
            historyRanges: this.ctx.history && this.ctx.history.periods || [],
            stringStaticRanges: apply('ranges', {
                ranges: this.ctx.ranges
            }),
            customPeriodText: this.ctx.customPeriodText || iget2('b-date-range-picker', 'vybrat', 'выбрать')
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            start = ctx.start,
            finish = ctx.finish,
            ranges = ctx.ranges || [],
            dateShift = ctx.dateShift || 0,
            chooserItem = [];

        if (typeof ctx.dateRange == 'number') {
            start = u['b-date-range-picker'].getDateFrom(ctx.dateRange + dateShift);
            finish = u['b-date-range-picker'].getDateFrom(dateShift);
        }

        if (ranges.length) {
            ranges.forEach(function(range, index) {
                chooserItem.push({
                    elem: 'item',
                    mix: {
                        block: 'b-date-range-picker',
                        elem: 'chooser-item'
                    },
                    js: {
                        title: range.title,
                        params: {
                            start: range.start,
                            finish: range.finish,
                            dependId: range.dependId
                        }
                    },
                    name: range.name || 'range-' + index,
                    content: range.title
                });
            });
        }

        if (ctx.history) {
            chooserItem.push({
                block: 'b-date-range-picker',
                elem: 'history-separator',
                content: iget2('b-date-range-picker', 'istoriya', 'История')
            });

            (ctx.history.periods || []).forEach(function(range, index) {
                chooserItem.push({
                    elem: 'item',
                    mix: {
                        block: 'b-date-range-picker',
                        elem: 'chooser-item'
                    },
                    js: {
                        title: iget2('b-date-range-picker', 'istoriya-100', 'история'),
                        params: {
                            history: true,
                            start: range.start,
                            finish: range.finish
                        }
                    },
                    name: range.name || 'history-range-' + index,
                    content: u['b-date-range-picker'].prettifyPeriod(range.start, range.finish)
                });
            });
        }

        return [
            {
                block: 'button',
                mods: {
                    pseudo: 'yes',
                    disabled: ctx.isSuperButtonDisabled ? 'yes' : ''
                },
                mix: {
                    block: 'b-date-range-picker',
                    elem: 'super-button'
                },
                content: [
                    {
                        block: 'b-icon',
                        mods: {
                            'size-16': 'calendar'
                        },
                        mix: [
                            {
                                block: 'b-date-range-picker',
                                elem: 'calendar-icon'
                            },
                            {
                                block: 'button',
                                elem: 'icon'
                            }
                        ]
                    },
                    {
                        block: 'b-date-range-picker',
                        elem: 'super-button-text',
                        tag: 'span',
                        content: u['b-date-range-picker'].prettifyPeriod(start, finish)
                    }
                ]
            },
            !!chooserItem.length && {
                elem: 'ranges',
                tag: 'span',
                content: {
                    block: 'dropdown',
                    mix: [
                        {
                            block: 'b-date-range-picker',
                            elem: 'ranges-dropdown'
                        },
                        {
                            block: 'b-dropdown-chooser',
                            js: true
                        }
                    ],
                    content: [
                        {
                            block: 'button',
                            mix: [
                                {
                                    block: 'dropdown',
                                    elem: 'switcher'
                                },
                                {
                                    block: 'b-date-range-picker',
                                    elem: 'dropdown-switcher'
                                }
                            ],
                            content: ctx.customPeriodText || iget2('b-date-range-picker', 'vybrat', 'выбрать')
                        },
                        {
                            block: 'popup',
                            mix: [
                                {
                                    block: 'dropdown',
                                    elem: 'popup'
                                },
                                {
                                    block: 'b-date-range-picker',
                                    elem: 'dropdown-popup'
                                }
                            ],
                            mods: {
                                adaptive: 'yes',
                                animate: 'no'
                            },
                            js: {
                                directions: ['bottom-left', 'top-left']
                            },
                            content: [
                                {
                                    elem: 'tail'
                                },
                                {
                                    elem: 'content',
                                    content: {
                                        block: 'b-chooser',
                                        mix: [
                                            {
                                                block: 'b-date-range-picker',
                                                elem: 'ranges-chooser'
                                            },
                                            {
                                                block: 'b-dropdown-chooser',
                                                elem: 'chooser'
                                            }
                                        ],
                                        content: chooserItem
                                    }
                                }
                            ]
                        }
                    ]
                }
            }
        ];
    })
);
