BEM.DOM.decl({ block: 'b-date-range-picker', modName: 'type', modVal: 'super' }, {

    onSetMod: {
        js: function() {
            this._updatePeriod({
                start: this.params.start,
                finish: this.params.finish
            });

            this._checkTemplates({
                start: this.params.start,
                finish: this.params.finish
            });

            this._superCalendar = this._createCalendar();

            if (this.getRangesChooser()) {
                this.getRangesChooser().on('change', function(e, data) {
                    if (data.selected && !data.extraParams.fromUpdatePeriod) {
                        this._onSelectStaticRange(data);
                    }
                }, this);
            }

            this.channel('b-date-range-picker').on('period-change', this._setRangeFromOther, this);
        }
    },

    /**
     * Устанавливает новое значение диапазона, если текущий зависит от другого календаря
     * @param {Event} e
     * @param {Object} data
     * @param {String} data.id
     * @param {Object} data.period
     * @private
     */
    _setRangeFromOther: function(e, data) {
        var selectedRange = this.getRangesChooser().getSelected() || {};

        if (selectedRange.params && selectedRange.params.dependId === data.id) {
            this._applyTemplate(selectedRange.params);
        }
    },

    /**
     * Возвращает dropdown шаблонов
     * @returns {BEM}
     */
    getPeriodsDropdown: function() {
        return this._periodsDropdown || (this._periodsDropdown = this.findBlockInside('ranges-dropdown', 'dropdown'));
    },

    /**
     * Возвращает кнопку по которой показываются шаблонов
     * @returns {BEM}
     */
    getDropdownSwitcher: function() {
        return this._dropdownSwitcher || (this._dropdownSwitcher = this.findBlockInside('dropdown-switcher', 'button'));
    },

    /**
     * Возвращает b-chooser
     * @returns {BEM}
     */
    getRangesChooser: function() {
        return this._periodChooser || (this._periodChooser = this.findBlockInside('ranges-chooser', 'b-chooser'));
    },

    /**
     * Меняет текст кнопки выбора шаблонов
     * @param {String} text - текст
     * @returns {BEM}
     * @private
     */
    _setSwitcherText: function(text) {
        if (this.getDropdownSwitcher()) {
            this.getDropdownSwitcher()
                .elem('text')
                .html(text);
        }

        return this;
    },

    /**
     * Выставляет период из шаблона
     * @param {Object} data - информация о шаблоне
     * @param {String} data.title - текст для пользователя
     * @param {Object} data.params - период
     * @param {Boolean} [data.history] - флаг, true если это шаблон относится к истории
     * @private
     */
    _onSelectStaticRange: function(data) {
        this._applyTemplate(data.params);
        this._setSwitcherText(data.title);

        this.getPeriodsDropdown().hide();

        if (data.params.history) {
            this._isRelativeRange = false;
        }
    },

    /**
     * Текущий выбранный период
     */
    _period: null,

    /**
     * Создает календарь
     * @returns {SuperCalendar}
     * @private
     */
    _createCalendar: function() {
        var calledElement = this.findElem('super-button'),
            params = this.params,
            limits = this._getLimits(),
            calendar;

        //cyn@TODO: костыль для работы супер-календаря
        if (!$.browser) {
            $.browser = {
                msie: BEM.blocks['i-ua'].ie
            };
        }

        // https://github.yandex-team.ru/Metrika/calendar/
        calendar = new SuperCalendar({
            title: false,                   // Ключ заголовка из локали для календаря, false если заголовок не нужно отображать
            resize: true,                   // Возможность изменять размер календаря
            center: params.center || false, // Центровка по ширине окна браузера
            shadow: false,                  // Тень
            animation: true,                // Анимация, в IE не поддерживается
            fullWidth: true,                // Возможность разворачивания на полный экран
            //mousewheel: true,            // Поддержка колесика мышки для изменение даты в календаре
            selectorWeeks: true,            // Быстрый выбор недели
            submitButton: 'ok',             // Название кнопки выбора даты
            speedAnimation: 'fast',         // Скорость анимации: slow, normal, fast
            maxDate: limits.maxDate && limits.maxDate.format('DD.MM.YYYY'), // Максимальная дата, всё что старше затеняется серым текстом и не выбирается
            minDate: limits.minDate.format('DD.MM.YYYY'), // Минимальная дата, всё что младше затеняется серым текстом и не выбирается
            maxYear: limits.maxDate && limits.maxDate.add(1, 'y').year(),   // Выше этого года дату не отображать
            minYear: limits.minDate.year(),               // Ниже этого года дату не отображать
            calledElement: calledElement,                 // Элемент при клике, вызывающий календарь
            positionElement: calledElement,               // Календарь позиционируется относительно этого элемента
            buttons: {
                close: true,    // Кнопка закрытия календаря
                maximize: false // Кнопка раскрытия календаря на весь экран
            },
            period: this._toCalendarPeriod(params.start, params.finish), // Выбранный период
            onSelect: this._onPeriodSelect.bind(this)                    // при выборе даты получает отформатированную дату
        });

        // показываем 3 месяца, 637px взято из минимальной ширины календаря
        calendar.jElement.css({ width: '637px' });

        return calendar;
    },

    _limits: null,

    /**
     * Возвращает максимальную и минимальную дату
     * @returns {{minDate: *, maxDate: *}}
     * @private
     */
    _getLimits: function() {
        if (this._limits) {
            return this._limits;
        }

        return this._limits = {
            minDate: this.params.minDate ? u.moment(this.params.minDate) : this.__self.MIN_DATE,
            maxDate: this.params.maxDate ? u.moment(this.params.maxDate) : undefined
        };
    },

    /**
     * Возвращает текущие значение диапазона
     * @returns {{start: String, finish: String}} Значения периодов
     */
    getRange: function() {
        return {
            start: u.moment(this._period.start).format(this.params.dateFormat),
            finish: u.moment(this._period.finish).format(this.params.dateFormat)
        };
    },

    /**
     * Устанавливает новое значение диапазона
     * @param {Object} ranges - значения периодов
     * @param {String} ranges.start - начало периода
     * @param {String} ranges.finish - конец периода
     * @returns {BEM}
     */
    setRange: function(ranges) {
        if (u['b-date-range-picker'].getDiff(this._getLimits().minDate, ranges.start, 'day') < 0) {
            ranges.start = this._getLimits().minDate;
        }
        if (u['b-date-range-picker'].getDiff(this._getLimits().maxDate, ranges.finish, 'day') > 0) {
            ranges.finish = this._getLimits().maxDate;
        }

        var calendarPeriod = this._toCalendarPeriod(ranges.start, ranges.finish),
            prettifyPeriod = u['b-date-range-picker'].prettifyPeriod(ranges.start, ranges.finish);

        this.elem('super-button-text')
            .html(prettifyPeriod);

        this._superCalendar.setPeriod(calendarPeriod);

        this._updatePeriod({
            start: ranges.start,
            finish: ranges.finish
        });

        this._checkTemplates({
            start: ranges.start,
            finish: ranges.finish
        });

        return this;
    },

    /**
     * Форматирует календарную дату, 12.12.2012 -> 2012-12-12
     * @param {String} date - дата
     * @param {String} [format] - формат
     * @returns {String}
     * @private
     */
    _changeCalendarDateFormat: function(date, format) {
        return u.moment(date.split('.').reverse().join('-')).format(format || 'YYYY-MM-DD');
    },

    /**
     * Запоминает выбранный период, обновляет текст кнопки
     * @param {Object} from
     * @param {Object} to
     * @private
     */
    _onPeriodSelect: function(from, to) {
        var start = this._changeCalendarDateFormat(from.text),
            finish = this._changeCalendarDateFormat(to.text),
            selectedPeriod = this.getRangesChooser() && this.getRangesChooser().getSelected();

        this._setSwitcherText(this.params.customPeriodText);

        this.elem('super-button-text')
            .html(u['b-date-range-picker'].prettifyPeriod(start, finish));

        if (selectedPeriod) {
            this.getRangesChooser().uncheck(selectedPeriod.name);
        }

        this._updatePeriod({
            start: start,
            finish: finish
        });

        this._checkTemplates({
            start: start,
            finish: finish
        });

        this.trigger('change', {
            start: start,
            finish: finish
        });

        return this;
    },

    /**
     * Возвращает разницу между start и finish
     * @param {String} [measurement] - Supported measurements are years, months, weeks, days, hours, minutes, and seconds.
     * @returns {Number}
     */
    getDiff: function(measurement) {
        return u['b-date-range-picker'].getDiff(this.getRange().start, this.getRange().finish, measurement);
    },

    /**
     * Возвращает разницу между start и текущей датой
     * @param {String} [measurement] - Supported measurements are years, months, weeks, days, hours, minutes, and seconds.
     * @returns {Number}
     */
    getShiftFromNow: function(measurement) {
        return u.moment(this.getRange()['start']).diff(u.moment(), measurement);
    },

    /**
     * Выбирает шаблон, если период выбран с помощью календаря и выбранный период совпадает с одним из шаблонов
     * @param {Object} period
     * @param {String} period.start - начало периода
     * @param {String} period.finish - конец периода
     * @returns {BEM}
     * @private
     */
    _checkTemplates: function(period) {
        if (!this.getRangesChooser()) {
            return this;
        }

        var currentTemplate;

        this.getRangesChooser()
            .getAll()
            .forEach(function(template) {
                var templateRange = this._getTemplateRange(template.params);

                if (!currentTemplate && period.start == templateRange.start && period.finish == templateRange.finish) {
                    currentTemplate = template;

                    this.getRangesChooser()
                        .check(template.name, { fromUpdatePeriod: true });

                    this._setSwitcherText(template.title);
                }
            }, this);

        return this;
    },

    /**
     * Форматирует период для SuperCalendar
     * @param {String} from - начало периода
     * @param {String} to - конец периода
     * @returns {Object}
     * @private
     */
    _toCalendarPeriod: function(from, to) {
        from = u.moment(from);
        to = u.moment(to);

        return {
            from: {
                day: from.get('date'),
                month: from.get('month'),
                year: from.get('year')
            },
            to: {
                day: to.get('date'),
                month: to.get('month'),
                year: to.get('year')
            }
        };
    }

}, {

    /**
     * Минимальная дата. Выбранный период должен начинаться не раньше 1 января 2000 года
     */
    MIN_DATE: u.moment('2001-01-01')
});
