block('b-date-range-picker')(

    js()(function() {
        var ctx = this.ctx,
            start = ctx.start,
            finish = ctx.finish,
            ranges = ctx.ranges || [],
            limits,
            jsParams = {
                dateFormat: ctx.dateFormat
            };

        jsParams.stringStaticRanges = apply('ranges', {
            ranges: ranges
        });

        start.limits && (limits = { start: start.limits });
        finish.limits && (limits = u._.extend(limits || {}, { finish: finish.limits }));

        ctx.id && (jsParams.id = ctx.id);
        limits && (jsParams.limits = limits);
        ctx.history && (jsParams.historyRanges = ctx.history.periods);

        return jsParams;
    }),

    mode('ranges')(function() {
        var ranges = this.ranges || [];

        return ranges.reduce(function(stringStaticRanges, range) {
            var start,
                finish;

            if (!u._.isUndefined(range.start) && !u._.isUndefined(range.finish)) {
                start = u['b-date-range-picker'].getDateFrom(range.start);
                finish = u['b-date-range-picker'].getDateFrom(range.finish);

                stringStaticRanges.push([start, finish].join(':'));
            }

            return stringStaticRanges;
        }, []);
    }),

    content()(function() {
        var ctx = this.ctx,
            start = ctx.start,
            finish = ctx.finish,
            ranges = ctx.ranges || [],
            dateFormat = ctx.dateFormat,
            viewFormat = ctx.viewFormat,
            dateShift = this.ctx.dateShift || 0;

        if (typeof this.ctx.dateRange == 'number') {
            start.value = u['b-date-range-picker'].getDateFrom(this.ctx.dateRange + dateShift);
            finish.value = u['b-date-range-picker'].getDateFrom(dateShift);
        }

        return [
            {
                block: 'b-date-input',
                mix: [{
                    block: 'b-date-range-picker',
                    elem: 'start'
                }],
                mods: ctx.inputMods || {},
                name: start.name || '',
                value: start.value,
                dateFormat: dateFormat,
                viewFormat: viewFormat,
                calendarMix: ctx.calendarMix
            },
            '&nbsp;&mdash;&nbsp;',
            {
                block: 'b-date-input',
                mix: [{
                    block: 'b-date-range-picker',
                    elem: 'finish'
                }],
                mods: ctx.inputMods || {},
                name: finish.name || '',
                value: finish.value,
                dateFormat: dateFormat,
                viewFormat: viewFormat,
                calendarMix: ctx.calendarMix,
                showYears: true
            },
            (ranges.length || ctx.history) && {
                elem: 'ranges',
                content: [
                    !!ranges.length && ranges.map(function(range) {
                        return {
                            block: 'link',
                            js: {
                                start: range.start,
                                finish: range.finish,
                                dependId: range.dependId
                            },
                            mods: { pseudo: 'yes' },
                            content: range.title
                        };
                    }),
                    ctx.history && {
                        block: 'link',
                        js: { type: 'history' },
                        mods: { pseudo: 'yes' },
                        content: ctx.history.title
                    }
                ]
            }
        ]
    })

);
