u.register({
    'b-date-range-picker': {

        /**
         * Возвращает дату в виде текста «4 августа – 21 октября 2015»
         * @param {String} start - начало периода
         * @param {String} finish - конец периода
         * @param {String} [dash] - разделитель
         * @returns {String}
         */
        prettifyPeriod: function(start, finish, dash) {
            start = u.moment(start);
            finish = u.moment(finish);
            dash || (dash = '&nbsp;&ndash;&nbsp;');

            var text = '';

            if (!finish.diff(start, 'days')) {
                return start.format('D MMMM YYYY');
            }

            if (start.year() === finish.year()) {
                if (start.month() === finish.month()) {
                    if (this.isFullMonth(start, finish)) {
                        return start.format('MMMM') + '&nbsp;' + start.year();
                    } else {
                        text = [
                            start.date(),
                            finish.format('D MMMM YYYY')
                        ];
                    }
                } else {
                    text = [
                        start.format('D MMMM'),
                        finish.format('D MMMM YYYY')
                    ];
                }
            } else {
                text = [
                    start.format('D MMMM YYYY'),
                    finish.format('D MMMM YYYY')
                ];
            }

            return text.join(dash);
        },

        /**
         * Проверяет, является ли заданный период целым месяцем
         * @param {String} start - начало периода
         * @param {String} finish - конец периода
         * @returns {boolean}
         */
        isFullMonth: function(start, finish) {
            if (typeof start == 'string') {
                start = u.moment(start);
            }

            if (typeof finish == 'string') {
                finish = u.moment(finish);
            }

            var startOfMonth = start.clone().startOf('month'),
                finishOfMonth = finish.clone().endOf('month');

            return start.diff(finish, 'month') === 0 &&
                start.date() === startOfMonth.date() && finish.date() === finishOfMonth.date();
        },

        /**
         * Возвращает разницу между start и finish
         * @param {String} start - начало периода
         * @param {String} finish - конец периода
         * @param {String} [measurement] - Supported measurements are years, months, weeks, days, hours, minutes, and seconds.
         * @returns {Number|Null}
         */
        getDiff: function(start, finish, measurement) {
            if (!start || !finish) {
                return null;
            }

            return u.moment(finish).diff(u.moment(start), measurement);
        },

        /**
         * Возвращает дату спустя d дней или другой величены
         * @param {Number|String|Object} to - количество дней, лет подробнее http://momentjs.com/docs/#/manipulating/add
         * @param {String} [start] - дата начала
         * @returns {String}
         */
        getDateFrom: function(to, start) {
            var startTime = u.moment(start),
                measurement = 'day',
                value;

            if (u._.isObject(to)) {
                measurement = u._.keys(to)[0];
                value = to[measurement];
            } else {
                value = to;
            }

            return startTime
                .add(value, measurement)
                .format('YYYY-MM-DD');
        }

    }
});
