block('b-day-budget-recommendation-notification')(
    js()(function() {
        return {
            cid: this.ctx.cid,
            ulogin: this.ctx.ulogin,
            key: 'auctionProbabilityNotificationId-' + this.ctx.cid,
            place: this.ctx.place
        };
    }),

    content()(function() {
        return {
            elem: 'placeholder'
        };
    }),

    elem('body')(
        content()(function() {
            var lostClicks = this.ctx.lostClicks,
                recommendedBudget = this.ctx.recommendedBudget,
                cid = this.ctx.cid,
                getPluralizeClicks = function(clicks) {
                    return iget2('b-day-budget-recommendation-notification', 'pluralize-clicks', '{number} клик', {
                        count: clicks,
                        some: '{number} клика',
                        many: '{number} кликов',
                        number: clicks
                    });
                },
                getPluralizeSum = function(sum) {
                    return iget2('b-day-budget-recommendation-notification', 'pluralize-sum', '{number} рубля', {
                        count: sum,
                        some: '{number} рублей',
                        many: '{number} рублей',
                        number: sum
                    });
                },
                text = iget2(
                    'b-day-budget-recommendation-notification',
                    'notification-text2',
                    'С текущими настройками кампания останавливается и теряет ~{clicks} в неделю. Увеличьте ограничение бюджета до {budget}.',
                    {
                        clicks: getPluralizeClicks(lostClicks),
                        budget: getPluralizeSum(recommendedBudget)
                    }
                );

            if (+lostClicks === 0) {
                text = iget2(
                    'b-day-budget-recommendation-notification',
                    'notification-text2-zero',
                    'С текущими настройками кампания останавливается и теряет клики. Увеличьте ограничение бюджета до {budget}.',
                    {
                        budget: getPluralizeSum(recommendedBudget)
                    }
                );
            }

            return {
                block: 'b-page-warning',
                mods: {
                    theme: 'inline-notification'
                },
                id: 'auctionProbabilityNotificationId-' + cid,
                pageWarningField: 'auctionProbabilityWarning',
                content: {
                    block: 'b-day-budget-recommendation-notification',
                    elem: 'content',
                    content: [
                        {
                            block: 'icon',
                            mix: {
                                block: 'b-day-budget-recommendation-notification',
                                elem: 'icon'
                            },
                            mods: {
                                'size-18': 'alert-white'
                            }
                        },
                        {
                            elem: 'text',
                            content: text
                        },
                        {
                            block: 'button2',
                            mix: { block: 'b-day-budget-recommendation-notification', elem: 'apply-button' },
                            mods: {
                                theme: 'normal',
                                size: 'm',
                                view: 'default',
                                tone: 'transparent'
                            },
                            text: iget2('b-day-budget-recommendation-notification', 'apply-button-text', 'Увеличить')
                        }
                    ]
                }
            };
        })
    )
);
