BEM.DOM.decl({ block: 'b-day-budget-recommendation-notification' }, {
    onSetMod: {
        js: function() {
            var params = this.params,
                cid = this.params.cid,
                ulogin = this.params.ulogin,
                key = this.params.key,
                place = this.params.place,
                dna = window.dna;

            if (dna && !u['b-page-warning'].isAlreadyHidden(key)) {
                var queryExecutor = dna.utils.getQueryExecutor(ulogin),
                    executeRecommendation = dna.utils.executeRecommendation,
                    captureException = dna.utils.captureException;

                queryExecutor.getCampaignRecommendations(ulogin, cid, u.consts('isModulesRecommendationsDnaEnabled'))
                    .then(function(dayBudgetRecomendations) {
                        if (dayBudgetRecomendations.length) {
                            var recommendation = dayBudgetRecomendations[0];
                            this.setMod('visible', 'yes');

                            BEM.blocks['b-metrika2'].params({
                                params: {
                                    'day-budget-recommendation': {
                                        type: 'new',
                                        place: place,
                                        event: 'show'
                                    }
                                }
                            });

                            BEM.DOM.replace(this.findElem('placeholder'), BEMHTML.apply({
                                block: 'b-day-budget-recommendation-notification',
                                elem: 'body',
                                lostClicks: recommendation.kpi.clicks,
                                recommendedBudget: recommendation.kpi.recommendedDailyBudget,
                                cid: cid
                            }));

                            var applyButton = this.findBlockOn('apply-button', 'button2'),
                                pageWarning = this.findBlockInside('b-page-warning'),
                                recommendationsKeys = recommendation.keys.map(function(key) {
                                    return u._.omit(key, '__typename');
                                });

                            applyButton.on('click', function() {
                                BEM.blocks['b-metrika2'].params({
                                    params: {
                                        'day-budget-recommendation': {
                                            type: 'new',
                                            place: place,
                                            event: 'apply'
                                        }
                                    }
                                });

                                applyButton.setMod('disabled', 'yes');

                                executeRecommendation(ulogin, recommendationsKeys, recommendation.newRecommendationAction)
                                    .then(function() {
                                        window.location.reload();
                                    })
                                    .catch(function() {
                                        BEM.DOM.destruct(this.findElem('body'));
                                    }.bind(this));
                            }.bind(this));

                            pageWarning.on('close', function() {
                                BEM.blocks['b-metrika2'].params({
                                    params: {
                                        'day-budget-recommendation': {
                                            type: 'new',
                                            place: place,
                                            event: 'close'
                                        }
                                    }
                                });
                            });
                        }
                    }.bind(this)).catch(function(err) {
                        captureException('yesReallyThisIsAnError', err, {
                            source: 'recommendations',
                            block: 'b-day-budget-recommendation-notification',
                            message: 'Query error: getCampaignRecommendations',
                            extra: {
                                login: ulogin
                            }
                        });
                    });
            }
        }
    }
});
